@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.VnetRouteResponse
import com.pulumi.azurenative.web.kotlin.outputs.VnetRouteResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [WebAppVnetConnection].
 */
@PulumiTagMarker
public class WebAppVnetConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppVnetConnectionArgs = WebAppVnetConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppVnetConnectionArgsBuilder.() -> Unit) {
        val builder = WebAppVnetConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAppVnetConnection {
        val builtJavaResource = com.pulumi.azurenative.web.WebAppVnetConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebAppVnetConnection(builtJavaResource)
    }
}

/**
 * Virtual Network information ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppVnetConnection myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}
 * ```
 */
public class WebAppVnetConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppVnetConnection,
) : KotlinCustomResource(javaResource, WebAppVnetConnectionMapper) {
    /**
     * A certificate file (.cer) blob containing the public key of the private key used to authenticate a
     * Point-To-Site VPN connection.
     */
    public val certBlob: Output<String>?
        get() = javaResource.certBlob().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The client certificate thumbprint.
     */
    public val certThumbprint: Output<String>
        get() = javaResource.certThumbprint().applyValue({ args0 -> args0 })

    /**
     * DNS servers to be used by this Virtual Network. This should be a comma-separated list of IP addresses.
     */
    public val dnsServers: Output<String>?
        get() = javaResource.dnsServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag that is used to denote if this is VNET injection
     */
    public val isSwift: Output<Boolean>?
        get() = javaResource.isSwift().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * <code>true</code> if a resync is required; otherwise, <code>false</code>.
     */
    public val resyncRequired: Output<Boolean>
        get() = javaResource.resyncRequired().applyValue({ args0 -> args0 })

    /**
     * The routes that this Virtual Network connection uses.
     */
    public val routes: Output<List<VnetRouteResponse>>
        get() = javaResource.routes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The Virtual Network's resource ID.
     */
    public val vnetResourceId: Output<String>?
        get() = javaResource.vnetResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object WebAppVnetConnectionMapper : ResourceMapper<WebAppVnetConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppVnetConnection::class == javaResource::class

    override fun map(javaResource: Resource): WebAppVnetConnection = WebAppVnetConnection(
        javaResource
            as com.pulumi.azurenative.web.WebAppVnetConnection,
    )
}

/**
 * @see [WebAppVnetConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppVnetConnection].
 */
public suspend fun webAppVnetConnection(
    name: String,
    block: suspend WebAppVnetConnectionResourceBuilder.() -> Unit,
): WebAppVnetConnection {
    val builder = WebAppVnetConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppVnetConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppVnetConnection(name: String): WebAppVnetConnection {
    val builder = WebAppVnetConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
