@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The default authentication provider to use when multiple providers are configured.
 * This setting is only needed if multiple providers are configured and the unauthenticated client
 * action is set to "RedirectToLoginPage".
 */
public enum class BuiltInAuthenticationProvider(
    public val javaValue: com.pulumi.azurenative.web.enums.BuiltInAuthenticationProvider,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.BuiltInAuthenticationProvider> {
    AzureActiveDirectory(com.pulumi.azurenative.web.enums.BuiltInAuthenticationProvider.AzureActiveDirectory),
    Facebook(com.pulumi.azurenative.web.enums.BuiltInAuthenticationProvider.Facebook),
    Google(com.pulumi.azurenative.web.enums.BuiltInAuthenticationProvider.Google),
    MicrosoftAccount(com.pulumi.azurenative.web.enums.BuiltInAuthenticationProvider.MicrosoftAccount),
    Twitter(com.pulumi.azurenative.web.enums.BuiltInAuthenticationProvider.Twitter),
    Github(com.pulumi.azurenative.web.enums.BuiltInAuthenticationProvider.Github),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.BuiltInAuthenticationProvider = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.BuiltInAuthenticationProvider):
            BuiltInAuthenticationProvider =
            BuiltInAuthenticationProvider.values().first { it.javaValue == javaType }
    }
}
