@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Database type (e.g. SqlAzure / MySql).
 */
public enum class DatabaseType(
    public val javaValue: com.pulumi.azurenative.web.enums.DatabaseType,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.DatabaseType> {
    SqlAzure(com.pulumi.azurenative.web.enums.DatabaseType.SqlAzure),
    MySql(com.pulumi.azurenative.web.enums.DatabaseType.MySql),
    LocalMySql(com.pulumi.azurenative.web.enums.DatabaseType.LocalMySql),
    PostgreSql(com.pulumi.azurenative.web.enums.DatabaseType.PostgreSql),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.DatabaseType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.DatabaseType): DatabaseType =
            DatabaseType.values().first { it.javaValue == javaType }
    }
}
