@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * SCM type.
 */
public enum class ScmType(
    public val javaValue: com.pulumi.azurenative.web.enums.ScmType,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.ScmType> {
    None(com.pulumi.azurenative.web.enums.ScmType.None),
    Dropbox(com.pulumi.azurenative.web.enums.ScmType.Dropbox),
    Tfs(com.pulumi.azurenative.web.enums.ScmType.Tfs),
    LocalGit(com.pulumi.azurenative.web.enums.ScmType.LocalGit),
    GitHub(com.pulumi.azurenative.web.enums.ScmType.GitHub),
    CodePlexGit(com.pulumi.azurenative.web.enums.ScmType.CodePlexGit),
    CodePlexHg(com.pulumi.azurenative.web.enums.ScmType.CodePlexHg),
    BitbucketGit(com.pulumi.azurenative.web.enums.ScmType.BitbucketGit),
    BitbucketHg(com.pulumi.azurenative.web.enums.ScmType.BitbucketHg),
    ExternalGit(com.pulumi.azurenative.web.enums.ScmType.ExternalGit),
    ExternalHg(com.pulumi.azurenative.web.enums.ScmType.ExternalHg),
    OneDrive(com.pulumi.azurenative.web.enums.ScmType.OneDrive),
    VSO(com.pulumi.azurenative.web.enums.ScmType.VSO),
    VSTSRM(com.pulumi.azurenative.web.enums.ScmType.VSTSRM),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.ScmType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.ScmType): ScmType =
            ScmType.values().first { it.javaValue == javaType }
    }
}
