@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ApiConnectionDefinitionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property api
 * @property changedTime Timestamp of last connection change
 * @property createdTime Timestamp of the connection creation
 * @property customParameterValues Dictionary of custom parameter values
 * @property displayName Display name
 * @property nonSecretParameterValues Dictionary of nonsecret parameter values
 * @property parameterValues Dictionary of parameter values
 * @property statuses Status of the connection
 * @property testLinks Links to test the API connection
 */
public data class ApiConnectionDefinitionPropertiesArgs(
    public val api: Output<ApiReferenceArgs>? = null,
    public val changedTime: Output<String>? = null,
    public val createdTime: Output<String>? = null,
    public val customParameterValues: Output<Map<String, String>>? = null,
    public val displayName: Output<String>? = null,
    public val nonSecretParameterValues: Output<Map<String, String>>? = null,
    public val parameterValues: Output<Map<String, String>>? = null,
    public val statuses: Output<List<ConnectionStatusDefinitionArgs>>? = null,
    public val testLinks: Output<List<ApiConnectionTestLinkArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ApiConnectionDefinitionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ApiConnectionDefinitionPropertiesArgs =
        com.pulumi.azurenative.web.inputs.ApiConnectionDefinitionPropertiesArgs.builder()
            .api(api?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .changedTime(changedTime?.applyValue({ args0 -> args0 }))
            .createdTime(createdTime?.applyValue({ args0 -> args0 }))
            .customParameterValues(
                customParameterValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .nonSecretParameterValues(
                nonSecretParameterValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .parameterValues(
                parameterValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .statuses(
                statuses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .testLinks(
                testLinks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApiConnectionDefinitionPropertiesArgs].
 */
@PulumiTagMarker
public class ApiConnectionDefinitionPropertiesArgsBuilder internal constructor() {
    private var api: Output<ApiReferenceArgs>? = null

    private var changedTime: Output<String>? = null

    private var createdTime: Output<String>? = null

    private var customParameterValues: Output<Map<String, String>>? = null

    private var displayName: Output<String>? = null

    private var nonSecretParameterValues: Output<Map<String, String>>? = null

    private var parameterValues: Output<Map<String, String>>? = null

    private var statuses: Output<List<ConnectionStatusDefinitionArgs>>? = null

    private var testLinks: Output<List<ApiConnectionTestLinkArgs>>? = null

    /**
     * @param value
     */
    @JvmName("hdqcraooudfgsndg")
    public suspend fun api(`value`: Output<ApiReferenceArgs>) {
        this.api = value
    }

    /**
     * @param value Timestamp of last connection change
     */
    @JvmName("notqbvoysufkasyy")
    public suspend fun changedTime(`value`: Output<String>) {
        this.changedTime = value
    }

    /**
     * @param value Timestamp of the connection creation
     */
    @JvmName("wgavcvclmpweptra")
    public suspend fun createdTime(`value`: Output<String>) {
        this.createdTime = value
    }

    /**
     * @param value Dictionary of custom parameter values
     */
    @JvmName("qginmxvbdlnbkqsd")
    public suspend fun customParameterValues(`value`: Output<Map<String, String>>) {
        this.customParameterValues = value
    }

    /**
     * @param value Display name
     */
    @JvmName("kmmflnwpwplupfhj")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Dictionary of nonsecret parameter values
     */
    @JvmName("jnptnxddigddttib")
    public suspend fun nonSecretParameterValues(`value`: Output<Map<String, String>>) {
        this.nonSecretParameterValues = value
    }

    /**
     * @param value Dictionary of parameter values
     */
    @JvmName("ibkkogiyyvlxfomi")
    public suspend fun parameterValues(`value`: Output<Map<String, String>>) {
        this.parameterValues = value
    }

    /**
     * @param value Status of the connection
     */
    @JvmName("ddgqjuqomagalxwn")
    public suspend fun statuses(`value`: Output<List<ConnectionStatusDefinitionArgs>>) {
        this.statuses = value
    }

    @JvmName("hjyauhflovxqyfmv")
    public suspend fun statuses(vararg values: Output<ConnectionStatusDefinitionArgs>) {
        this.statuses = Output.all(values.asList())
    }

    /**
     * @param values Status of the connection
     */
    @JvmName("ndykrjdkfpwjoyvq")
    public suspend fun statuses(values: List<Output<ConnectionStatusDefinitionArgs>>) {
        this.statuses = Output.all(values)
    }

    /**
     * @param value Links to test the API connection
     */
    @JvmName("eljhxeavmskxpjyl")
    public suspend fun testLinks(`value`: Output<List<ApiConnectionTestLinkArgs>>) {
        this.testLinks = value
    }

    @JvmName("tspqjhbwxgecstkv")
    public suspend fun testLinks(vararg values: Output<ApiConnectionTestLinkArgs>) {
        this.testLinks = Output.all(values.asList())
    }

    /**
     * @param values Links to test the API connection
     */
    @JvmName("fyhrfelepwnabuch")
    public suspend fun testLinks(values: List<Output<ApiConnectionTestLinkArgs>>) {
        this.testLinks = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("euhfxvrtequtcrhf")
    public suspend fun api(`value`: ApiReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.api = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cjlkqivxgeaikjch")
    public suspend fun api(argument: suspend ApiReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ApiReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.api = mapped
    }

    /**
     * @param value Timestamp of last connection change
     */
    @JvmName("wdnlelkfgfdfbvgj")
    public suspend fun changedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changedTime = mapped
    }

    /**
     * @param value Timestamp of the connection creation
     */
    @JvmName("qrpjcrvlhvjmdvpg")
    public suspend fun createdTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdTime = mapped
    }

    /**
     * @param value Dictionary of custom parameter values
     */
    @JvmName("gfojqdbhvdlfrumw")
    public suspend fun customParameterValues(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customParameterValues = mapped
    }

    /**
     * @param values Dictionary of custom parameter values
     */
    @JvmName("ybawrivbpxtnancl")
    public fun customParameterValues(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customParameterValues = mapped
    }

    /**
     * @param value Display name
     */
    @JvmName("kbbxpwbntfibujdq")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Dictionary of nonsecret parameter values
     */
    @JvmName("ogellkqiyfgynfav")
    public suspend fun nonSecretParameterValues(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nonSecretParameterValues = mapped
    }

    /**
     * @param values Dictionary of nonsecret parameter values
     */
    @JvmName("fhfmqfqaacuqqovl")
    public fun nonSecretParameterValues(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nonSecretParameterValues = mapped
    }

    /**
     * @param value Dictionary of parameter values
     */
    @JvmName("xsrmtjyfgqqfcjmc")
    public suspend fun parameterValues(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterValues = mapped
    }

    /**
     * @param values Dictionary of parameter values
     */
    @JvmName("dgumrbvhblpmexxc")
    public fun parameterValues(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterValues = mapped
    }

    /**
     * @param value Status of the connection
     */
    @JvmName("svsqwuuqtsqojhfa")
    public suspend fun statuses(`value`: List<ConnectionStatusDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statuses = mapped
    }

    /**
     * @param argument Status of the connection
     */
    @JvmName("wsvphxaedtnimuyx")
    public suspend
    fun statuses(argument: List<suspend ConnectionStatusDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectionStatusDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statuses = mapped
    }

    /**
     * @param argument Status of the connection
     */
    @JvmName("uffyaduecjaavitb")
    public suspend fun statuses(
        vararg
        argument: suspend ConnectionStatusDefinitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConnectionStatusDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statuses = mapped
    }

    /**
     * @param argument Status of the connection
     */
    @JvmName("trnfsrpewinqnudq")
    public suspend fun statuses(argument: suspend ConnectionStatusDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConnectionStatusDefinitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.statuses = mapped
    }

    /**
     * @param values Status of the connection
     */
    @JvmName("iwyxhgvmwaxwbjyk")
    public suspend fun statuses(vararg values: ConnectionStatusDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statuses = mapped
    }

    /**
     * @param value Links to test the API connection
     */
    @JvmName("qqajaunjguiwnpcf")
    public suspend fun testLinks(`value`: List<ApiConnectionTestLinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testLinks = mapped
    }

    /**
     * @param argument Links to test the API connection
     */
    @JvmName("rkfvatgbpyacfvjg")
    public suspend
    fun testLinks(argument: List<suspend ApiConnectionTestLinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApiConnectionTestLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.testLinks = mapped
    }

    /**
     * @param argument Links to test the API connection
     */
    @JvmName("pbyrdheahmkmexhm")
    public suspend fun testLinks(
        vararg
        argument: suspend ApiConnectionTestLinkArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApiConnectionTestLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.testLinks = mapped
    }

    /**
     * @param argument Links to test the API connection
     */
    @JvmName("vlixgnkettmxqech")
    public suspend fun testLinks(argument: suspend ApiConnectionTestLinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ApiConnectionTestLinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.testLinks = mapped
    }

    /**
     * @param values Links to test the API connection
     */
    @JvmName("wyhyopdqpjeeajim")
    public suspend fun testLinks(vararg values: ApiConnectionTestLinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.testLinks = mapped
    }

    internal fun build(): ApiConnectionDefinitionPropertiesArgs =
        ApiConnectionDefinitionPropertiesArgs(
            api = api,
            changedTime = changedTime,
            createdTime = createdTime,
            customParameterValues = customParameterValues,
            displayName = displayName,
            nonSecretParameterValues = nonSecretParameterValues,
            parameterValues = parameterValues,
            statuses = statuses,
            testLinks = testLinks,
        )
}
