@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ApiOAuthSettingsParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * OAuth settings for the API
 * @property options Options available to this parameter
 * @property uiDefinition UI definitions per culture as caller can specify the culture
 * @property value Value of the setting
 */
public data class ApiOAuthSettingsParameterArgs(
    public val options: Output<Any>? = null,
    public val uiDefinition: Output<Any>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ApiOAuthSettingsParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ApiOAuthSettingsParameterArgs =
        com.pulumi.azurenative.web.inputs.ApiOAuthSettingsParameterArgs.builder()
            .options(options?.applyValue({ args0 -> args0 }))
            .uiDefinition(uiDefinition?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiOAuthSettingsParameterArgs].
 */
@PulumiTagMarker
public class ApiOAuthSettingsParameterArgsBuilder internal constructor() {
    private var options: Output<Any>? = null

    private var uiDefinition: Output<Any>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Options available to this parameter
     */
    @JvmName("eclyathyrbuoendc")
    public suspend fun options(`value`: Output<Any>) {
        this.options = value
    }

    /**
     * @param value UI definitions per culture as caller can specify the culture
     */
    @JvmName("irdnmddtoxikxges")
    public suspend fun uiDefinition(`value`: Output<Any>) {
        this.uiDefinition = value
    }

    /**
     * @param value Value of the setting
     */
    @JvmName("rcyumhvpmvnepjpr")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Options available to this parameter
     */
    @JvmName("bysqtccseoimnqty")
    public suspend fun options(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param value UI definitions per culture as caller can specify the culture
     */
    @JvmName("hkrtovwtdwgmkxqx")
    public suspend fun uiDefinition(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uiDefinition = mapped
    }

    /**
     * @param value Value of the setting
     */
    @JvmName("fewkthahsxfeuryl")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ApiOAuthSettingsParameterArgs = ApiOAuthSettingsParameterArgs(
        options = options,
        uiDefinition = uiDefinition,
        `value` = `value`,
    )
}
