@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ApiReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property brandColor Brand color
 * @property description The custom API description
 * @property displayName The display name
 * @property iconUri The icon URI
 * @property id Resource reference id
 * @property name The name of the API
 * @property swagger The JSON representation of the swagger
 * @property type Resource reference type
 */
public data class ApiReferenceArgs(
    public val brandColor: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val iconUri: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val swagger: Output<Any>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ApiReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ApiReferenceArgs =
        com.pulumi.azurenative.web.inputs.ApiReferenceArgs.builder()
            .brandColor(brandColor?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .iconUri(iconUri?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .swagger(swagger?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiReferenceArgs].
 */
@PulumiTagMarker
public class ApiReferenceArgsBuilder internal constructor() {
    private var brandColor: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var iconUri: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var swagger: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Brand color
     */
    @JvmName("tiiiotkjsldjwlmt")
    public suspend fun brandColor(`value`: Output<String>) {
        this.brandColor = value
    }

    /**
     * @param value The custom API description
     */
    @JvmName("ylankufmomljftme")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name
     */
    @JvmName("ilwtiubchdboobth")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The icon URI
     */
    @JvmName("bvhlwhrncurbppgl")
    public suspend fun iconUri(`value`: Output<String>) {
        this.iconUri = value
    }

    /**
     * @param value Resource reference id
     */
    @JvmName("ftodpuyssaulukfu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the API
     */
    @JvmName("jsswxyepgxsaqrsc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The JSON representation of the swagger
     */
    @JvmName("rhtvcbatukyqouxw")
    public suspend fun swagger(`value`: Output<Any>) {
        this.swagger = value
    }

    /**
     * @param value Resource reference type
     */
    @JvmName("qxsykmbpbfkkokna")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Brand color
     */
    @JvmName("bstdyqtrqremxcon")
    public suspend fun brandColor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.brandColor = mapped
    }

    /**
     * @param value The custom API description
     */
    @JvmName("gvkvxrjucpnnnbyt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name
     */
    @JvmName("otcnsufnjrwjkbxx")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The icon URI
     */
    @JvmName("wkjvcclemdmswhsg")
    public suspend fun iconUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iconUri = mapped
    }

    /**
     * @param value Resource reference id
     */
    @JvmName("yudckfwbofhmlkwa")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the API
     */
    @JvmName("xejomgeobhakpxva")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The JSON representation of the swagger
     */
    @JvmName("epprggkdysvwywry")
    public suspend fun swagger(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.swagger = mapped
    }

    /**
     * @param value Resource reference type
     */
    @JvmName("qdvrrjyjilpviray")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ApiReferenceArgs = ApiReferenceArgs(
        brandColor = brandColor,
        description = description,
        displayName = displayName,
        iconUri = iconUri,
        id = id,
        name = name,
        swagger = swagger,
        type = type,
    )
}
