@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AppRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the app registration for providers that have app ids and app secrets
 * @property appId The App ID of the app used for login.
 * @property appSecretSettingName The app setting name that contains the app secret.
 */
public data class AppRegistrationArgs(
    public val appId: Output<String>? = null,
    public val appSecretSettingName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AppRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AppRegistrationArgs =
        com.pulumi.azurenative.web.inputs.AppRegistrationArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .appSecretSettingName(appSecretSettingName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppRegistrationArgs].
 */
@PulumiTagMarker
public class AppRegistrationArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var appSecretSettingName: Output<String>? = null

    /**
     * @param value The App ID of the app used for login.
     */
    @JvmName("byndwccuqcaalbbh")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value The app setting name that contains the app secret.
     */
    @JvmName("gicguimyclekkpjl")
    public suspend fun appSecretSettingName(`value`: Output<String>) {
        this.appSecretSettingName = value
    }

    /**
     * @param value The App ID of the app used for login.
     */
    @JvmName("aymuqqeglqvitupn")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value The app setting name that contains the app secret.
     */
    @JvmName("vllmliuxhqftvluo")
    public suspend fun appSecretSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSecretSettingName = mapped
    }

    internal fun build(): AppRegistrationArgs = AppRegistrationArgs(
        appId = appId,
        appSecretSettingName = appSecretSettingName,
    )
}
