@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AutoHealActionsArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.AutoHealActionType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Actions which to take by the auto-heal module when a rule is triggered.
 * @property actionType Predefined action to be taken.
 * @property customAction Custom action to be taken.
 * @property minProcessExecutionTime Minimum time the process must execute
 * before taking the action
 */
public data class AutoHealActionsArgs(
    public val actionType: Output<AutoHealActionType>? = null,
    public val customAction: Output<AutoHealCustomActionArgs>? = null,
    public val minProcessExecutionTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AutoHealActionsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AutoHealActionsArgs =
        com.pulumi.azurenative.web.inputs.AutoHealActionsArgs.builder()
            .actionType(actionType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customAction(customAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .minProcessExecutionTime(minProcessExecutionTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoHealActionsArgs].
 */
@PulumiTagMarker
public class AutoHealActionsArgsBuilder internal constructor() {
    private var actionType: Output<AutoHealActionType>? = null

    private var customAction: Output<AutoHealCustomActionArgs>? = null

    private var minProcessExecutionTime: Output<String>? = null

    /**
     * @param value Predefined action to be taken.
     */
    @JvmName("cetffupcunxugwva")
    public suspend fun actionType(`value`: Output<AutoHealActionType>) {
        this.actionType = value
    }

    /**
     * @param value Custom action to be taken.
     */
    @JvmName("vhkmkcmtlwapbfwq")
    public suspend fun customAction(`value`: Output<AutoHealCustomActionArgs>) {
        this.customAction = value
    }

    /**
     * @param value Minimum time the process must execute
     * before taking the action
     */
    @JvmName("cwakvaftupvtjdjd")
    public suspend fun minProcessExecutionTime(`value`: Output<String>) {
        this.minProcessExecutionTime = value
    }

    /**
     * @param value Predefined action to be taken.
     */
    @JvmName("htbrpyposxaepdfc")
    public suspend fun actionType(`value`: AutoHealActionType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value Custom action to be taken.
     */
    @JvmName("pqmsbdladntfoerc")
    public suspend fun customAction(`value`: AutoHealCustomActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customAction = mapped
    }

    /**
     * @param argument Custom action to be taken.
     */
    @JvmName("tpliohmossuuusdo")
    public suspend fun customAction(argument: suspend AutoHealCustomActionArgsBuilder.() -> Unit) {
        val toBeMapped = AutoHealCustomActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customAction = mapped
    }

    /**
     * @param value Minimum time the process must execute
     * before taking the action
     */
    @JvmName("uarrapsjkytwmivl")
    public suspend fun minProcessExecutionTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minProcessExecutionTime = mapped
    }

    internal fun build(): AutoHealActionsArgs = AutoHealActionsArgs(
        actionType = actionType,
        customAction = customAction,
        minProcessExecutionTime = minProcessExecutionTime,
    )
}
