@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.BackupSchedule.builder
import com.pulumi.azurenative.web.kotlin.enums.FrequencyUnit
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.
 * @property frequencyInterval How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
 * @property frequencyUnit The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
 * @property keepAtLeastOneBackup True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
 * @property retentionPeriodInDays After how many days backups should be deleted.
 * @property startTime When the schedule should start working.
 */
public data class BackupSchedule(
    public val frequencyInterval: Int,
    public val frequencyUnit: FrequencyUnit,
    public val keepAtLeastOneBackup: Boolean,
    public val retentionPeriodInDays: Int,
    public val startTime: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.BackupSchedule> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.BackupSchedule =
        com.pulumi.azurenative.web.inputs.BackupSchedule.builder()
            .frequencyInterval(frequencyInterval.let({ args0 -> args0 }))
            .frequencyUnit(frequencyUnit.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keepAtLeastOneBackup(keepAtLeastOneBackup.let({ args0 -> args0 }))
            .retentionPeriodInDays(retentionPeriodInDays.let({ args0 -> args0 }))
            .startTime(startTime?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupSchedule].
 */
@PulumiTagMarker
public class BackupScheduleBuilder internal constructor() {
    private var frequencyInterval: Int? = null

    private var frequencyUnit: FrequencyUnit? = null

    private var keepAtLeastOneBackup: Boolean? = null

    private var retentionPeriodInDays: Int? = null

    private var startTime: String? = null

    /**
     * @param value How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
     */
    @JvmName("cswxjrfcsbpdaobj")
    public suspend fun frequencyInterval(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.frequencyInterval = mapped
    }

    /**
     * @param value The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
     */
    @JvmName("bhhfdkblwghonunt")
    public suspend fun frequencyUnit(`value`: FrequencyUnit) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.frequencyUnit = mapped
    }

    /**
     * @param value True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
     */
    @JvmName("denpfddekkbndoyy")
    public suspend fun keepAtLeastOneBackup(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keepAtLeastOneBackup = mapped
    }

    /**
     * @param value After how many days backups should be deleted.
     */
    @JvmName("njlwmbptmqvlemou")
    public suspend fun retentionPeriodInDays(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.retentionPeriodInDays = mapped
    }

    /**
     * @param value When the schedule should start working.
     */
    @JvmName("elnsukxnvfawsqus")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startTime = mapped
    }

    internal fun build(): BackupSchedule = BackupSchedule(
        frequencyInterval = frequencyInterval ?: throw PulumiNullFieldException("frequencyInterval"),
        frequencyUnit = frequencyUnit ?: throw PulumiNullFieldException("frequencyUnit"),
        keepAtLeastOneBackup = keepAtLeastOneBackup ?: throw
            PulumiNullFieldException("keepAtLeastOneBackup"),
        retentionPeriodInDays = retentionPeriodInDays ?: throw
            PulumiNullFieldException("retentionPeriodInDays"),
        startTime = startTime,
    )
}
