@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.BackupScheduleArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.FrequencyUnit
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.
 * @property frequencyInterval How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
 * @property frequencyUnit The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
 * @property keepAtLeastOneBackup True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
 * @property retentionPeriodInDays After how many days backups should be deleted.
 * @property startTime When the schedule should start working.
 */
public data class BackupScheduleArgs(
    public val frequencyInterval: Output<Int>,
    public val frequencyUnit: Output<FrequencyUnit>,
    public val keepAtLeastOneBackup: Output<Boolean>,
    public val retentionPeriodInDays: Output<Int>,
    public val startTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.BackupScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.BackupScheduleArgs =
        com.pulumi.azurenative.web.inputs.BackupScheduleArgs.builder()
            .frequencyInterval(frequencyInterval.applyValue({ args0 -> args0 }))
            .frequencyUnit(frequencyUnit.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keepAtLeastOneBackup(keepAtLeastOneBackup.applyValue({ args0 -> args0 }))
            .retentionPeriodInDays(retentionPeriodInDays.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupScheduleArgs].
 */
@PulumiTagMarker
public class BackupScheduleArgsBuilder internal constructor() {
    private var frequencyInterval: Output<Int>? = null

    private var frequencyUnit: Output<FrequencyUnit>? = null

    private var keepAtLeastOneBackup: Output<Boolean>? = null

    private var retentionPeriodInDays: Output<Int>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
     */
    @JvmName("tafskoxoffqdcpmq")
    public suspend fun frequencyInterval(`value`: Output<Int>) {
        this.frequencyInterval = value
    }

    /**
     * @param value The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
     */
    @JvmName("hrwcekhjbbvsloia")
    public suspend fun frequencyUnit(`value`: Output<FrequencyUnit>) {
        this.frequencyUnit = value
    }

    /**
     * @param value True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
     */
    @JvmName("rsxqkwamauyvqbvw")
    public suspend fun keepAtLeastOneBackup(`value`: Output<Boolean>) {
        this.keepAtLeastOneBackup = value
    }

    /**
     * @param value After how many days backups should be deleted.
     */
    @JvmName("gstdixcjieghdxqy")
    public suspend fun retentionPeriodInDays(`value`: Output<Int>) {
        this.retentionPeriodInDays = value
    }

    /**
     * @param value When the schedule should start working.
     */
    @JvmName("jcpduptagkreypch")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
     */
    @JvmName("gybpbjrmusxtdcmg")
    public suspend fun frequencyInterval(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequencyInterval = mapped
    }

    /**
     * @param value The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
     */
    @JvmName("yixjviwywvndhibu")
    public suspend fun frequencyUnit(`value`: FrequencyUnit) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequencyUnit = mapped
    }

    /**
     * @param value True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
     */
    @JvmName("djlmorsprojafsic")
    public suspend fun keepAtLeastOneBackup(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keepAtLeastOneBackup = mapped
    }

    /**
     * @param value After how many days backups should be deleted.
     */
    @JvmName("urcojoneobaokssm")
    public suspend fun retentionPeriodInDays(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPeriodInDays = mapped
    }

    /**
     * @param value When the schedule should start working.
     */
    @JvmName("idonuhjmwabivovv")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): BackupScheduleArgs = BackupScheduleArgs(
        frequencyInterval = frequencyInterval ?: throw PulumiNullFieldException("frequencyInterval"),
        frequencyUnit = frequencyUnit ?: throw PulumiNullFieldException("frequencyUnit"),
        keepAtLeastOneBackup = keepAtLeastOneBackup ?: throw
            PulumiNullFieldException("keepAtLeastOneBackup"),
        retentionPeriodInDays = retentionPeriodInDays ?: throw
            PulumiNullFieldException("retentionPeriodInDays"),
        startTime = startTime,
    )
}
