@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.CloningInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Information needed for cloning operation.
 * @property appSettingsOverrides Application setting overrides for cloned app. If specified, these settings override the settings cloned
 * from source app. Otherwise, application settings from source app are retained.
 * @property cloneCustomHostNames <code>true</code> to clone custom hostnames from source app; otherwise, <code>false</code>.
 * @property cloneSourceControl <code>true</code> to clone source control from source app; otherwise, <code>false</code>.
 * @property configureLoadBalancing <code>true</code> to configure load balancing for source and destination app.
 * @property correlationId Correlation ID of cloning operation. This ID ties multiple cloning operations
 * together to use the same snapshot.
 * @property hostingEnvironment App Service Environment.
 * @property overwrite <code>true</code> to overwrite destination app; otherwise, <code>false</code>.
 * @property sourceWebAppId ARM resource ID of the source app. App resource ID is of the form
 * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and
 * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots.
 * @property sourceWebAppLocation Location of source app ex: West US or North Europe
 * @property trafficManagerProfileId ARM resource ID of the Traffic Manager profile to use, if it exists. Traffic Manager resource ID is of the form
 * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
 * @property trafficManagerProfileName Name of Traffic Manager profile to create. This is only needed if Traffic Manager profile does not already exist.
 */
public data class CloningInfoArgs(
    public val appSettingsOverrides: Output<Map<String, String>>? = null,
    public val cloneCustomHostNames: Output<Boolean>? = null,
    public val cloneSourceControl: Output<Boolean>? = null,
    public val configureLoadBalancing: Output<Boolean>? = null,
    public val correlationId: Output<String>? = null,
    public val hostingEnvironment: Output<String>? = null,
    public val overwrite: Output<Boolean>? = null,
    public val sourceWebAppId: Output<String>,
    public val sourceWebAppLocation: Output<String>? = null,
    public val trafficManagerProfileId: Output<String>? = null,
    public val trafficManagerProfileName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.CloningInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.CloningInfoArgs =
        com.pulumi.azurenative.web.inputs.CloningInfoArgs.builder()
            .appSettingsOverrides(
                appSettingsOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .cloneCustomHostNames(cloneCustomHostNames?.applyValue({ args0 -> args0 }))
            .cloneSourceControl(cloneSourceControl?.applyValue({ args0 -> args0 }))
            .configureLoadBalancing(configureLoadBalancing?.applyValue({ args0 -> args0 }))
            .correlationId(correlationId?.applyValue({ args0 -> args0 }))
            .hostingEnvironment(hostingEnvironment?.applyValue({ args0 -> args0 }))
            .overwrite(overwrite?.applyValue({ args0 -> args0 }))
            .sourceWebAppId(sourceWebAppId.applyValue({ args0 -> args0 }))
            .sourceWebAppLocation(sourceWebAppLocation?.applyValue({ args0 -> args0 }))
            .trafficManagerProfileId(trafficManagerProfileId?.applyValue({ args0 -> args0 }))
            .trafficManagerProfileName(trafficManagerProfileName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloningInfoArgs].
 */
@PulumiTagMarker
public class CloningInfoArgsBuilder internal constructor() {
    private var appSettingsOverrides: Output<Map<String, String>>? = null

    private var cloneCustomHostNames: Output<Boolean>? = null

    private var cloneSourceControl: Output<Boolean>? = null

    private var configureLoadBalancing: Output<Boolean>? = null

    private var correlationId: Output<String>? = null

    private var hostingEnvironment: Output<String>? = null

    private var overwrite: Output<Boolean>? = null

    private var sourceWebAppId: Output<String>? = null

    private var sourceWebAppLocation: Output<String>? = null

    private var trafficManagerProfileId: Output<String>? = null

    private var trafficManagerProfileName: Output<String>? = null

    /**
     * @param value Application setting overrides for cloned app. If specified, these settings override the settings cloned
     * from source app. Otherwise, application settings from source app are retained.
     */
    @JvmName("kjvtnrnayvjblnmg")
    public suspend fun appSettingsOverrides(`value`: Output<Map<String, String>>) {
        this.appSettingsOverrides = value
    }

    /**
     * @param value <code>true</code> to clone custom hostnames from source app; otherwise, <code>false</code>.
     */
    @JvmName("sggmmcogosmsttrf")
    public suspend fun cloneCustomHostNames(`value`: Output<Boolean>) {
        this.cloneCustomHostNames = value
    }

    /**
     * @param value <code>true</code> to clone source control from source app; otherwise, <code>false</code>.
     */
    @JvmName("bfwbgqutortlteox")
    public suspend fun cloneSourceControl(`value`: Output<Boolean>) {
        this.cloneSourceControl = value
    }

    /**
     * @param value <code>true</code> to configure load balancing for source and destination app.
     */
    @JvmName("scmotpxvlimuwlne")
    public suspend fun configureLoadBalancing(`value`: Output<Boolean>) {
        this.configureLoadBalancing = value
    }

    /**
     * @param value Correlation ID of cloning operation. This ID ties multiple cloning operations
     * together to use the same snapshot.
     */
    @JvmName("yrvagbykhdeqfpcx")
    public suspend fun correlationId(`value`: Output<String>) {
        this.correlationId = value
    }

    /**
     * @param value App Service Environment.
     */
    @JvmName("aqwpjxkohfrxqarp")
    public suspend fun hostingEnvironment(`value`: Output<String>) {
        this.hostingEnvironment = value
    }

    /**
     * @param value <code>true</code> to overwrite destination app; otherwise, <code>false</code>.
     */
    @JvmName("kagejqlwxgqlvsxp")
    public suspend fun overwrite(`value`: Output<Boolean>) {
        this.overwrite = value
    }

    /**
     * @param value ARM resource ID of the source app. App resource ID is of the form
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots.
     */
    @JvmName("mhsxalvkpattohck")
    public suspend fun sourceWebAppId(`value`: Output<String>) {
        this.sourceWebAppId = value
    }

    /**
     * @param value Location of source app ex: West US or North Europe
     */
    @JvmName("gndmernpfwnsuxjv")
    public suspend fun sourceWebAppLocation(`value`: Output<String>) {
        this.sourceWebAppLocation = value
    }

    /**
     * @param value ARM resource ID of the Traffic Manager profile to use, if it exists. Traffic Manager resource ID is of the form
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
     */
    @JvmName("jxrvmqfmbutflown")
    public suspend fun trafficManagerProfileId(`value`: Output<String>) {
        this.trafficManagerProfileId = value
    }

    /**
     * @param value Name of Traffic Manager profile to create. This is only needed if Traffic Manager profile does not already exist.
     */
    @JvmName("dmcmakfxellamkcs")
    public suspend fun trafficManagerProfileName(`value`: Output<String>) {
        this.trafficManagerProfileName = value
    }

    /**
     * @param value Application setting overrides for cloned app. If specified, these settings override the settings cloned
     * from source app. Otherwise, application settings from source app are retained.
     */
    @JvmName("nioeisbjnshnchbh")
    public suspend fun appSettingsOverrides(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSettingsOverrides = mapped
    }

    /**
     * @param values Application setting overrides for cloned app. If specified, these settings override the settings cloned
     * from source app. Otherwise, application settings from source app are retained.
     */
    @JvmName("lxosxvidisimndxi")
    public fun appSettingsOverrides(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appSettingsOverrides = mapped
    }

    /**
     * @param value <code>true</code> to clone custom hostnames from source app; otherwise, <code>false</code>.
     */
    @JvmName("lcyysxuatyxolynd")
    public suspend fun cloneCustomHostNames(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloneCustomHostNames = mapped
    }

    /**
     * @param value <code>true</code> to clone source control from source app; otherwise, <code>false</code>.
     */
    @JvmName("rcvpsvkgnbaoicna")
    public suspend fun cloneSourceControl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloneSourceControl = mapped
    }

    /**
     * @param value <code>true</code> to configure load balancing for source and destination app.
     */
    @JvmName("imabyoapgdtssrcr")
    public suspend fun configureLoadBalancing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configureLoadBalancing = mapped
    }

    /**
     * @param value Correlation ID of cloning operation. This ID ties multiple cloning operations
     * together to use the same snapshot.
     */
    @JvmName("hgxkccdyvdwhiprw")
    public suspend fun correlationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.correlationId = mapped
    }

    /**
     * @param value App Service Environment.
     */
    @JvmName("veqmxwskifnoolfd")
    public suspend fun hostingEnvironment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostingEnvironment = mapped
    }

    /**
     * @param value <code>true</code> to overwrite destination app; otherwise, <code>false</code>.
     */
    @JvmName("djnryfpcpobtomen")
    public suspend fun overwrite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overwrite = mapped
    }

    /**
     * @param value ARM resource ID of the source app. App resource ID is of the form
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots.
     */
    @JvmName("rusbfccttapuretw")
    public suspend fun sourceWebAppId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceWebAppId = mapped
    }

    /**
     * @param value Location of source app ex: West US or North Europe
     */
    @JvmName("jtukcwlxcoktawdd")
    public suspend fun sourceWebAppLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceWebAppLocation = mapped
    }

    /**
     * @param value ARM resource ID of the Traffic Manager profile to use, if it exists. Traffic Manager resource ID is of the form
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
     */
    @JvmName("gglxmkggkewawdyv")
    public suspend fun trafficManagerProfileId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficManagerProfileId = mapped
    }

    /**
     * @param value Name of Traffic Manager profile to create. This is only needed if Traffic Manager profile does not already exist.
     */
    @JvmName("enqkhdgtedaxadjn")
    public suspend fun trafficManagerProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficManagerProfileName = mapped
    }

    internal fun build(): CloningInfoArgs = CloningInfoArgs(
        appSettingsOverrides = appSettingsOverrides,
        cloneCustomHostNames = cloneCustomHostNames,
        cloneSourceControl = cloneSourceControl,
        configureLoadBalancing = configureLoadBalancing,
        correlationId = correlationId,
        hostingEnvironment = hostingEnvironment,
        overwrite = overwrite,
        sourceWebAppId = sourceWebAppId ?: throw PulumiNullFieldException("sourceWebAppId"),
        sourceWebAppLocation = sourceWebAppLocation,
        trafficManagerProfileId = trafficManagerProfileId,
        trafficManagerProfileName = trafficManagerProfileName,
    )
}
