@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ConfigurationArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.ActiveRevisionsMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Non versioned Container App configuration properties that define the mutable settings of a Container app
 * @property activeRevisionsMode ActiveRevisionsMode controls how active revisions are handled for the Container app:
 * <list><item>Multiple: multiple revisions can be active. If no value if provided, this is the default</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode</item></list>
 * @property ingress Ingress configurations.
 * @property registries Collection of private container registry credentials for containers used by the Container app
 * @property secrets Collection of secrets used by a Container app
 */
public data class ConfigurationArgs(
    public val activeRevisionsMode: Output<Either<String, ActiveRevisionsMode>>? = null,
    public val ingress: Output<IngressArgs>? = null,
    public val registries: Output<List<RegistryCredentialsArgs>>? = null,
    public val secrets: Output<List<SecretArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ConfigurationArgs =
        com.pulumi.azurenative.web.inputs.ConfigurationArgs.builder()
            .activeRevisionsMode(
                activeRevisionsMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .ingress(ingress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registries(
                registries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .secrets(
                secrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConfigurationArgs].
 */
@PulumiTagMarker
public class ConfigurationArgsBuilder internal constructor() {
    private var activeRevisionsMode: Output<Either<String, ActiveRevisionsMode>>? = null

    private var ingress: Output<IngressArgs>? = null

    private var registries: Output<List<RegistryCredentialsArgs>>? = null

    private var secrets: Output<List<SecretArgs>>? = null

    /**
     * @param value ActiveRevisionsMode controls how active revisions are handled for the Container app:
     * <list><item>Multiple: multiple revisions can be active. If no value if provided, this is the default</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode</item></list>
     */
    @JvmName("ieuwcxqwvxolgfcj")
    public suspend fun activeRevisionsMode(`value`: Output<Either<String, ActiveRevisionsMode>>) {
        this.activeRevisionsMode = value
    }

    /**
     * @param value Ingress configurations.
     */
    @JvmName("xbjomxvupxlkehah")
    public suspend fun ingress(`value`: Output<IngressArgs>) {
        this.ingress = value
    }

    /**
     * @param value Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("xjviixwosrtylgqf")
    public suspend fun registries(`value`: Output<List<RegistryCredentialsArgs>>) {
        this.registries = value
    }

    @JvmName("rcawfadqrpdadmba")
    public suspend fun registries(vararg values: Output<RegistryCredentialsArgs>) {
        this.registries = Output.all(values.asList())
    }

    /**
     * @param values Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("bqgqktboyvjedwen")
    public suspend fun registries(values: List<Output<RegistryCredentialsArgs>>) {
        this.registries = Output.all(values)
    }

    /**
     * @param value Collection of secrets used by a Container app
     */
    @JvmName("ebiluwgwwskxncid")
    public suspend fun secrets(`value`: Output<List<SecretArgs>>) {
        this.secrets = value
    }

    @JvmName("swysenbcmmmjcwor")
    public suspend fun secrets(vararg values: Output<SecretArgs>) {
        this.secrets = Output.all(values.asList())
    }

    /**
     * @param values Collection of secrets used by a Container app
     */
    @JvmName("nyslwkbxytwqttxp")
    public suspend fun secrets(values: List<Output<SecretArgs>>) {
        this.secrets = Output.all(values)
    }

    /**
     * @param value ActiveRevisionsMode controls how active revisions are handled for the Container app:
     * <list><item>Multiple: multiple revisions can be active. If no value if provided, this is the default</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode</item></list>
     */
    @JvmName("wgonkjkptxsmpkmc")
    public suspend fun activeRevisionsMode(`value`: Either<String, ActiveRevisionsMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeRevisionsMode = mapped
    }

    /**
     * @param value ActiveRevisionsMode controls how active revisions are handled for the Container app:
     * <list><item>Multiple: multiple revisions can be active. If no value if provided, this is the default</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode</item></list>
     */
    @JvmName("ilsdfqesbiyarhcg")
    public fun activeRevisionsMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActiveRevisionsMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activeRevisionsMode = mapped
    }

    /**
     * @param value ActiveRevisionsMode controls how active revisions are handled for the Container app:
     * <list><item>Multiple: multiple revisions can be active. If no value if provided, this is the default</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode</item></list>
     */
    @JvmName("qvielywkdwcdydrv")
    public fun activeRevisionsMode(`value`: ActiveRevisionsMode) {
        val toBeMapped = Either.ofRight<String, ActiveRevisionsMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activeRevisionsMode = mapped
    }

    /**
     * @param value Ingress configurations.
     */
    @JvmName("hundgupwkbjiudpw")
    public suspend fun ingress(`value`: IngressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingress = mapped
    }

    /**
     * @param argument Ingress configurations.
     */
    @JvmName("eorxxssaebvwxkew")
    public suspend fun ingress(argument: suspend IngressArgsBuilder.() -> Unit) {
        val toBeMapped = IngressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param value Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("cutmnxricmmkppvg")
    public suspend fun registries(`value`: List<RegistryCredentialsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registries = mapped
    }

    /**
     * @param argument Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("owrmbbtvharfkpbn")
    public suspend fun registries(argument: List<suspend RegistryCredentialsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegistryCredentialsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.registries = mapped
    }

    /**
     * @param argument Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("ppyqhamwnuyvmrne")
    public suspend fun registries(
        vararg
        argument: suspend RegistryCredentialsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RegistryCredentialsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.registries = mapped
    }

    /**
     * @param argument Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("foobioupfwhsfwqy")
    public suspend fun registries(argument: suspend RegistryCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RegistryCredentialsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.registries = mapped
    }

    /**
     * @param values Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("nrddupjhougkkrad")
    public suspend fun registries(vararg values: RegistryCredentialsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registries = mapped
    }

    /**
     * @param value Collection of secrets used by a Container app
     */
    @JvmName("damgyqbmosnrwmky")
    public suspend fun secrets(`value`: List<SecretArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param argument Collection of secrets used by a Container app
     */
    @JvmName("wtyuvnqelvlinqyo")
    public suspend fun secrets(argument: List<suspend SecretArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SecretArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Collection of secrets used by a Container app
     */
    @JvmName("erxqynifodhbxbyq")
    public suspend fun secrets(vararg argument: suspend SecretArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SecretArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Collection of secrets used by a Container app
     */
    @JvmName("qauocxiwuuafskky")
    public suspend fun secrets(argument: suspend SecretArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SecretArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param values Collection of secrets used by a Container app
     */
    @JvmName("pbsjvtbeglayglgv")
    public suspend fun secrets(vararg values: SecretArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    internal fun build(): ConfigurationArgs = ConfigurationArgs(
        activeRevisionsMode = activeRevisionsMode,
        ingress = ingress,
        registries = registries,
        secrets = secrets,
    )
}
