@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ConnectionErrorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Connection error
 * @property code Code of the status
 * @property etag Resource ETag
 * @property location Resource location
 * @property message Description of the status
 * @property tags Resource tags
 */
public data class ConnectionErrorArgs(
    public val code: Output<String>? = null,
    public val etag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val message: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ConnectionErrorArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ConnectionErrorArgs =
        com.pulumi.azurenative.web.inputs.ConnectionErrorArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectionErrorArgs].
 */
@PulumiTagMarker
public class ConnectionErrorArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var etag: Output<String>? = null

    private var location: Output<String>? = null

    private var message: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Code of the status
     */
    @JvmName("pjjasdummldiqocl")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Resource ETag
     */
    @JvmName("bdlcrlphdwyjrpyn")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("calbxeoykcgjsrrs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Description of the status
     */
    @JvmName("ssrsqtkorfaootms")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("gexovpnidymqwlqs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Code of the status
     */
    @JvmName("notcfyrttrubybwl")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Resource ETag
     */
    @JvmName("xxhloetakfkfrnbj")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("haibatldnxinbdce")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Description of the status
     */
    @JvmName("mdfpovftxjxgqrbt")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("qofnbcsmprxmmfpo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("puuofviirywupcac")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectionErrorArgs = ConnectionErrorArgs(
        code = code,
        etag = etag,
        location = location,
        message = message,
        tags = tags,
    )
}
