@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ConnectionStatusDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Connection status
 * @property error Connection error
 * @property status The gateway status
 * @property target Target of the error
 */
public data class ConnectionStatusDefinitionArgs(
    public val error: Output<ConnectionErrorArgs>? = null,
    public val status: Output<String>? = null,
    public val target: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ConnectionStatusDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ConnectionStatusDefinitionArgs =
        com.pulumi.azurenative.web.inputs.ConnectionStatusDefinitionArgs.builder()
            .error(error?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(status?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionStatusDefinitionArgs].
 */
@PulumiTagMarker
public class ConnectionStatusDefinitionArgsBuilder internal constructor() {
    private var error: Output<ConnectionErrorArgs>? = null

    private var status: Output<String>? = null

    private var target: Output<String>? = null

    /**
     * @param value Connection error
     */
    @JvmName("cldyebbjghvwhsjf")
    public suspend fun error(`value`: Output<ConnectionErrorArgs>) {
        this.error = value
    }

    /**
     * @param value The gateway status
     */
    @JvmName("ptlybsauskjrngsg")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Target of the error
     */
    @JvmName("uoyvboxsimmskoke")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Connection error
     */
    @JvmName("ygfwxxjfidtrdpmn")
    public suspend fun error(`value`: ConnectionErrorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.error = mapped
    }

    /**
     * @param argument Connection error
     */
    @JvmName("ilexnrmsqkjidbhh")
    public suspend fun error(argument: suspend ConnectionErrorArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionErrorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.error = mapped
    }

    /**
     * @param value The gateway status
     */
    @JvmName("wihwoytfnhkwayim")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Target of the error
     */
    @JvmName("radtcitbvrxghbls")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): ConnectionStatusDefinitionArgs = ConnectionStatusDefinitionArgs(
        error = error,
        status = status,
        target = target,
    )
}
