@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ContainerResourcesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Container App container resource requirements.
 * @property cpu Required CPU in cores, e.g. 0.5
 * @property memory Required memory, e.g. "250Mb"
 */
public data class ContainerResourcesArgs(
    public val cpu: Output<Double>? = null,
    public val memory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ContainerResourcesArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ContainerResourcesArgs =
        com.pulumi.azurenative.web.inputs.ContainerResourcesArgs.builder()
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerResourcesArgs].
 */
@PulumiTagMarker
public class ContainerResourcesArgsBuilder internal constructor() {
    private var cpu: Output<Double>? = null

    private var memory: Output<String>? = null

    /**
     * @param value Required CPU in cores, e.g. 0.5
     */
    @JvmName("fchsniltgvhnjfhj")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value Required memory, e.g. "250Mb"
     */
    @JvmName("opralymmgtpcjneh")
    public suspend fun memory(`value`: Output<String>) {
        this.memory = value
    }

    /**
     * @param value Required CPU in cores, e.g. 0.5
     */
    @JvmName("ujuibsfpikrhlydt")
    public suspend fun cpu(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value Required memory, e.g. "250Mb"
     */
    @JvmName("epsubceynysapyrp")
    public suspend fun memory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    internal fun build(): ContainerResourcesArgs = ContainerResourcesArgs(
        cpu = cpu,
        memory = memory,
    )
}
