@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.DaprComponentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Dapr component configuration
 * @property metadata Component metadata
 * @property name Component name
 * @property type Component type
 * @property version Component version
 */
public data class DaprComponentArgs(
    public val metadata: Output<List<DaprMetadataArgs>>? = null,
    public val name: Output<String>? = null,
    public val type: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.DaprComponentArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.DaprComponentArgs =
        com.pulumi.azurenative.web.inputs.DaprComponentArgs.builder()
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DaprComponentArgs].
 */
@PulumiTagMarker
public class DaprComponentArgsBuilder internal constructor() {
    private var metadata: Output<List<DaprMetadataArgs>>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Component metadata
     */
    @JvmName("yxjnkgxmkoowbjvi")
    public suspend fun metadata(`value`: Output<List<DaprMetadataArgs>>) {
        this.metadata = value
    }

    @JvmName("woyytmohijckfhow")
    public suspend fun metadata(vararg values: Output<DaprMetadataArgs>) {
        this.metadata = Output.all(values.asList())
    }

    /**
     * @param values Component metadata
     */
    @JvmName("amxfcuyyrhnsetbs")
    public suspend fun metadata(values: List<Output<DaprMetadataArgs>>) {
        this.metadata = Output.all(values)
    }

    /**
     * @param value Component name
     */
    @JvmName("hsdtctfhvckmuwlp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Component type
     */
    @JvmName("jxsrdkutsraysnak")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Component version
     */
    @JvmName("jcckkwpcnwpocgkt")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Component metadata
     */
    @JvmName("prvgygppoyiebkvy")
    public suspend fun metadata(`value`: List<DaprMetadataArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument Component metadata
     */
    @JvmName("niplnxgsplqxyphb")
    public suspend fun metadata(argument: List<suspend DaprMetadataArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DaprMetadataArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Component metadata
     */
    @JvmName("jcawrmyrqegmgbvj")
    public suspend fun metadata(vararg argument: suspend DaprMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DaprMetadataArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Component metadata
     */
    @JvmName("mmhchldqtmyhjmhp")
    public suspend fun metadata(argument: suspend DaprMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DaprMetadataArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param values Component metadata
     */
    @JvmName("uyqalcukcvcmjckc")
    public suspend fun metadata(vararg values: DaprMetadataArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value Component name
     */
    @JvmName("opxukhkidvgqmsrv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Component type
     */
    @JvmName("xyehiouvncmxbxvt")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Component version
     */
    @JvmName("rvpkbpvrdwedkqwi")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): DaprComponentArgs = DaprComponentArgs(
        metadata = metadata,
        name = name,
        type = type,
        version = version,
    )
}
