@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.EnabledConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Enabled configuration.
 * @property enabled True if configuration is enabled, false if it is disabled and null if configuration is not set.
 */
public data class EnabledConfigArgs(
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.EnabledConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.EnabledConfigArgs =
        com.pulumi.azurenative.web.inputs.EnabledConfigArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnabledConfigArgs].
 */
@PulumiTagMarker
public class EnabledConfigArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value True if configuration is enabled, false if it is disabled and null if configuration is not set.
     */
    @JvmName("aacgdthlwmhtioju")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value True if configuration is enabled, false if it is disabled and null if configuration is not set.
     */
    @JvmName("tidjmpkykpqphflm")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): EnabledConfigArgs = EnabledConfigArgs(
        enabled = enabled,
    )
}
