@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.EnvironmentVarArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Container App container environment variable.
 * @property name Environment variable name.
 * @property secretRef Name of the Container App secret from which to pull the environment variable value.
 * @property value Non-secret environment variable value.
 */
public data class EnvironmentVarArgs(
    public val name: Output<String>? = null,
    public val secretRef: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.EnvironmentVarArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.EnvironmentVarArgs =
        com.pulumi.azurenative.web.inputs.EnvironmentVarArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .secretRef(secretRef?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentVarArgs].
 */
@PulumiTagMarker
public class EnvironmentVarArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var secretRef: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Environment variable name.
     */
    @JvmName("iqtmailfuuxocoac")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the Container App secret from which to pull the environment variable value.
     */
    @JvmName("vlveehycxhneojhq")
    public suspend fun secretRef(`value`: Output<String>) {
        this.secretRef = value
    }

    /**
     * @param value Non-secret environment variable value.
     */
    @JvmName("bdxunwmcysmvsskc")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Environment variable name.
     */
    @JvmName("eyjnrdvhbwqkrknv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the Container App secret from which to pull the environment variable value.
     */
    @JvmName("nrkmqohcpwblfrth")
    public suspend fun secretRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretRef = mapped
    }

    /**
     * @param value Non-secret environment variable value.
     */
    @JvmName("ubivjepmvvrxpnrc")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EnvironmentVarArgs = EnvironmentVarArgs(
        name = name,
        secretRef = secretRef,
        `value` = `value`,
    )
}
