@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.FacebookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The configuration settings of the Facebook provider.
 * @property enabled <code>false</code> if the Facebook provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property graphApiVersion The version of the Facebook api to be used while logging in.
 * @property login The configuration settings of the login flow.
 * @property registration The configuration settings of the app registration for the Facebook provider.
 */
public data class FacebookArgs(
    public val enabled: Output<Boolean>? = null,
    public val graphApiVersion: Output<String>? = null,
    public val login: Output<LoginScopesArgs>? = null,
    public val registration: Output<AppRegistrationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.FacebookArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.FacebookArgs =
        com.pulumi.azurenative.web.inputs.FacebookArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .graphApiVersion(graphApiVersion?.applyValue({ args0 -> args0 }))
            .login(login?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registration(registration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FacebookArgs].
 */
@PulumiTagMarker
public class FacebookArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var graphApiVersion: Output<String>? = null

    private var login: Output<LoginScopesArgs>? = null

    private var registration: Output<AppRegistrationArgs>? = null

    /**
     * @param value <code>false</code> if the Facebook provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("xfhjvalithuwhcey")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The version of the Facebook api to be used while logging in.
     */
    @JvmName("ivhwuqgqdjajtqoi")
    public suspend fun graphApiVersion(`value`: Output<String>) {
        this.graphApiVersion = value
    }

    /**
     * @param value The configuration settings of the login flow.
     */
    @JvmName("pnksidbgjvxlswra")
    public suspend fun login(`value`: Output<LoginScopesArgs>) {
        this.login = value
    }

    /**
     * @param value The configuration settings of the app registration for the Facebook provider.
     */
    @JvmName("urvwrqvlhprharlu")
    public suspend fun registration(`value`: Output<AppRegistrationArgs>) {
        this.registration = value
    }

    /**
     * @param value <code>false</code> if the Facebook provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("qrulloxfaftgtqjv")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The version of the Facebook api to be used while logging in.
     */
    @JvmName("gkbamdkdaikvnopm")
    public suspend fun graphApiVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.graphApiVersion = mapped
    }

    /**
     * @param value The configuration settings of the login flow.
     */
    @JvmName("keiifymnrooxgmln")
    public suspend fun login(`value`: LoginScopesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.login = mapped
    }

    /**
     * @param argument The configuration settings of the login flow.
     */
    @JvmName("ceagyumkjqywktfw")
    public suspend fun login(argument: suspend LoginScopesArgsBuilder.() -> Unit) {
        val toBeMapped = LoginScopesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.login = mapped
    }

    /**
     * @param value The configuration settings of the app registration for the Facebook provider.
     */
    @JvmName("jpegxridffenajyf")
    public suspend fun registration(`value`: AppRegistrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registration = mapped
    }

    /**
     * @param argument The configuration settings of the app registration for the Facebook provider.
     */
    @JvmName("ubmrthlqbxepmigt")
    public suspend fun registration(argument: suspend AppRegistrationArgsBuilder.() -> Unit) {
        val toBeMapped = AppRegistrationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.registration = mapped
    }

    internal fun build(): FacebookArgs = FacebookArgs(
        enabled = enabled,
        graphApiVersion = graphApiVersion,
        login = login,
        registration = registration,
    )
}
