@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.FileSystemHttpLogsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Http logs to file system configuration.
 * @property enabled True if configuration is enabled, false if it is disabled and null if configuration is not set.
 * @property retentionInDays Retention in days.
 * Remove files older than X days.
 * 0 or lower means no retention.
 * @property retentionInMb Maximum size in megabytes that http log files can use.
 * When reached old log files will be removed to make space for new ones.
 * Value can range between 25 and 100.
 */
public data class FileSystemHttpLogsConfigArgs(
    public val enabled: Output<Boolean>? = null,
    public val retentionInDays: Output<Int>? = null,
    public val retentionInMb: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.FileSystemHttpLogsConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.FileSystemHttpLogsConfigArgs =
        com.pulumi.azurenative.web.inputs.FileSystemHttpLogsConfigArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .retentionInDays(retentionInDays?.applyValue({ args0 -> args0 }))
            .retentionInMb(retentionInMb?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileSystemHttpLogsConfigArgs].
 */
@PulumiTagMarker
public class FileSystemHttpLogsConfigArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var retentionInDays: Output<Int>? = null

    private var retentionInMb: Output<Int>? = null

    /**
     * @param value True if configuration is enabled, false if it is disabled and null if configuration is not set.
     */
    @JvmName("rctlgjiohqoidcgb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Retention in days.
     * Remove files older than X days.
     * 0 or lower means no retention.
     */
    @JvmName("oqybsekvlowymknu")
    public suspend fun retentionInDays(`value`: Output<Int>) {
        this.retentionInDays = value
    }

    /**
     * @param value Maximum size in megabytes that http log files can use.
     * When reached old log files will be removed to make space for new ones.
     * Value can range between 25 and 100.
     */
    @JvmName("wfloxuoogglnaktl")
    public suspend fun retentionInMb(`value`: Output<Int>) {
        this.retentionInMb = value
    }

    /**
     * @param value True if configuration is enabled, false if it is disabled and null if configuration is not set.
     */
    @JvmName("bqbckboaobntftcp")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Retention in days.
     * Remove files older than X days.
     * 0 or lower means no retention.
     */
    @JvmName("xpivavrmhpmqymyg")
    public suspend fun retentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionInDays = mapped
    }

    /**
     * @param value Maximum size in megabytes that http log files can use.
     * When reached old log files will be removed to make space for new ones.
     * Value can range between 25 and 100.
     */
    @JvmName("yrgfclgmvuwtmvyt")
    public suspend fun retentionInMb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionInMb = mapped
    }

    internal fun build(): FileSystemHttpLogsConfigArgs = FileSystemHttpLogsConfigArgs(
        enabled = enabled,
        retentionInDays = retentionInDays,
        retentionInMb = retentionInMb,
    )
}
