@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.FrontEndConfigurationArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.FrontEndServiceType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kind
 */
public data class FrontEndConfigurationArgs(
    public val kind: Output<FrontEndServiceType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.FrontEndConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.FrontEndConfigurationArgs =
        com.pulumi.azurenative.web.inputs.FrontEndConfigurationArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FrontEndConfigurationArgs].
 */
@PulumiTagMarker
public class FrontEndConfigurationArgsBuilder internal constructor() {
    private var kind: Output<FrontEndServiceType>? = null

    /**
     * @param value
     */
    @JvmName("aubnkubgdmvttixc")
    public suspend fun kind(`value`: Output<FrontEndServiceType>) {
        this.kind = value
    }

    /**
     * @param value
     */
    @JvmName("iwifklndmriiaxou")
    public suspend fun kind(`value`: FrontEndServiceType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    internal fun build(): FrontEndConfigurationArgs = FrontEndConfigurationArgs(
        kind = kind,
    )
}
