@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetStaticSiteBuildDatabaseConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseConnectionName Name of the database connection.
 * @property environmentName The stage site identifier.
 * @property name Name of the static site
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetStaticSiteBuildDatabaseConnectionPlainArgs(
    public val databaseConnectionName: String,
    public val environmentName: String,
    public val name: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetStaticSiteBuildDatabaseConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.web.inputs.GetStaticSiteBuildDatabaseConnectionPlainArgs =
        com.pulumi.azurenative.web.inputs.GetStaticSiteBuildDatabaseConnectionPlainArgs.builder()
            .databaseConnectionName(databaseConnectionName.let({ args0 -> args0 }))
            .environmentName(environmentName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStaticSiteBuildDatabaseConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetStaticSiteBuildDatabaseConnectionPlainArgsBuilder internal constructor() {
    private var databaseConnectionName: String? = null

    private var environmentName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the database connection.
     */
    @JvmName("hkkfcoibdbcfolma")
    public suspend fun databaseConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseConnectionName = mapped
    }

    /**
     * @param value The stage site identifier.
     */
    @JvmName("blehxrwynsmraibc")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value Name of the static site
     */
    @JvmName("elmbpfyqxfgajrde")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ikkugxxjebomrnia")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetStaticSiteBuildDatabaseConnectionPlainArgs =
        GetStaticSiteBuildDatabaseConnectionPlainArgs(
            databaseConnectionName = databaseConnectionName ?: throw
                PulumiNullFieldException("databaseConnectionName"),
            environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
