@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetStaticSiteLinkedBackendForBuildPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentName The stage site identifier
 * @property linkedBackendName Name of the linked backend that should be retrieved
 * @property name Name of the static site
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetStaticSiteLinkedBackendForBuildPlainArgs(
    public val environmentName: String,
    public val linkedBackendName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetStaticSiteLinkedBackendForBuildPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.web.inputs.GetStaticSiteLinkedBackendForBuildPlainArgs =
        com.pulumi.azurenative.web.inputs.GetStaticSiteLinkedBackendForBuildPlainArgs.builder()
            .environmentName(environmentName.let({ args0 -> args0 }))
            .linkedBackendName(linkedBackendName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStaticSiteLinkedBackendForBuildPlainArgs].
 */
@PulumiTagMarker
public class GetStaticSiteLinkedBackendForBuildPlainArgsBuilder internal constructor() {
    private var environmentName: String? = null

    private var linkedBackendName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The stage site identifier
     */
    @JvmName("gdylssgabemkupdx")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value Name of the linked backend that should be retrieved
     */
    @JvmName("jhsfhhjjblduutnq")
    public suspend fun linkedBackendName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkedBackendName = mapped
    }

    /**
     * @param value Name of the static site
     */
    @JvmName("lpttkxuhdomnjyrh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("nalycfasvrqshrdc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetStaticSiteLinkedBackendForBuildPlainArgs =
        GetStaticSiteLinkedBackendForBuildPlainArgs(
            environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
            linkedBackendName = linkedBackendName ?: throw PulumiNullFieldException("linkedBackendName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
