@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetStaticSiteUserProvidedFunctionAppForStaticSiteBuildPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentName The stage site identifier.
 * @property functionAppName Name of the function app registered with the static site build.
 * @property name Name of the static site.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetStaticSiteUserProvidedFunctionAppForStaticSiteBuildPlainArgs(
    public val environmentName: String,
    public val functionAppName: String,
    public val name: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetStaticSiteUserProvidedFunctionAppForStaticSiteBuildPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.web.inputs.GetStaticSiteUserProvidedFunctionAppForStaticSiteBuildPlainArgs =
        com.pulumi.azurenative.web.inputs.GetStaticSiteUserProvidedFunctionAppForStaticSiteBuildPlainArgs.builder()
            .environmentName(environmentName.let({ args0 -> args0 }))
            .functionAppName(functionAppName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStaticSiteUserProvidedFunctionAppForStaticSiteBuildPlainArgs].
 */
@PulumiTagMarker
public class GetStaticSiteUserProvidedFunctionAppForStaticSiteBuildPlainArgsBuilder internal
constructor() {
    private var environmentName: String? = null

    private var functionAppName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The stage site identifier.
     */
    @JvmName("gbeijbnlowjtohgn")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value Name of the function app registered with the static site build.
     */
    @JvmName("qadqledeolqsnrvc")
    public suspend fun functionAppName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.functionAppName = mapped
    }

    /**
     * @param value Name of the static site.
     */
    @JvmName("gyyxgnlkclyjwmrr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("jdgrkqmqhqupifcf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetStaticSiteUserProvidedFunctionAppForStaticSiteBuildPlainArgs =
        GetStaticSiteUserProvidedFunctionAppForStaticSiteBuildPlainArgs(
            environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
            functionAppName = functionAppName ?: throw PulumiNullFieldException("functionAppName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
