@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetStaticSiteUserProvidedFunctionAppForStaticSitePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property functionAppName Name of the function app registered with the static site.
 * @property name Name of the static site.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetStaticSiteUserProvidedFunctionAppForStaticSitePlainArgs(
    public val functionAppName: String,
    public val name: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetStaticSiteUserProvidedFunctionAppForStaticSitePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.web.inputs.GetStaticSiteUserProvidedFunctionAppForStaticSitePlainArgs =
        com.pulumi.azurenative.web.inputs.GetStaticSiteUserProvidedFunctionAppForStaticSitePlainArgs.builder()
            .functionAppName(functionAppName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStaticSiteUserProvidedFunctionAppForStaticSitePlainArgs].
 */
@PulumiTagMarker
public class GetStaticSiteUserProvidedFunctionAppForStaticSitePlainArgsBuilder internal
constructor() {
    private var functionAppName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the function app registered with the static site.
     */
    @JvmName("hdjrbbgmwtfpfece")
    public suspend fun functionAppName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.functionAppName = mapped
    }

    /**
     * @param value Name of the static site.
     */
    @JvmName("xtpdbyubfxmhavix")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("nmdmyppoinidadix")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetStaticSiteUserProvidedFunctionAppForStaticSitePlainArgs =
        GetStaticSiteUserProvidedFunctionAppForStaticSitePlainArgs(
            functionAppName = functionAppName ?: throw PulumiNullFieldException("functionAppName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
