@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppDeploymentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id Deployment ID.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetWebAppDeploymentPlainArgs(
    public val id: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppDeploymentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppDeploymentPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppDeploymentPlainArgs.builder()
            .id(id.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppDeploymentPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppDeploymentPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Deployment ID.
     */
    @JvmName("oicwaxdqhvitwqxf")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("uuhlocxvwcyeqias")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("intgaaepnqwrxsvs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWebAppDeploymentPlainArgs = GetWebAppDeploymentPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
