@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppInstanceFunctionSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property functionName Function name.
 * @property name Site name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot.
 */
public data class GetWebAppInstanceFunctionSlotPlainArgs(
    public val functionName: String,
    public val name: String,
    public val resourceGroupName: String,
    public val slot: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppInstanceFunctionSlotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppInstanceFunctionSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppInstanceFunctionSlotPlainArgs.builder()
            .functionName(functionName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppInstanceFunctionSlotPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppInstanceFunctionSlotPlainArgsBuilder internal constructor() {
    private var functionName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var slot: String? = null

    /**
     * @param value Function name.
     */
    @JvmName("vhhwdxwemqcmmmky")
    public suspend fun functionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.functionName = mapped
    }

    /**
     * @param value Site name.
     */
    @JvmName("qmsccjsibdnbkwad")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("cxxtnofffiegpgvx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot.
     */
    @JvmName("rbwnptjikiyucewa")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    internal fun build(): GetWebAppInstanceFunctionSlotPlainArgs =
        GetWebAppInstanceFunctionSlotPlainArgs(
            functionName = functionName ?: throw PulumiNullFieldException("functionName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            slot = slot ?: throw PulumiNullFieldException("slot"),
        )
}
