@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppPrivateEndpointConnectionSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the site.
 * @property privateEndpointConnectionName Name of the private endpoint connection.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the site deployment slot.
 */
public data class GetWebAppPrivateEndpointConnectionSlotPlainArgs(
    public val name: String,
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
    public val slot: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppPrivateEndpointConnectionSlotPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.web.inputs.GetWebAppPrivateEndpointConnectionSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppPrivateEndpointConnectionSlotPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppPrivateEndpointConnectionSlotPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppPrivateEndpointConnectionSlotPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    private var slot: String? = null

    /**
     * @param value Name of the site.
     */
    @JvmName("cmjjafoblimtpvrq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the private endpoint connection.
     */
    @JvmName("rfyrpucpghsqrtqp")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("msyeasbgcxwxnosj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the site deployment slot.
     */
    @JvmName("rjvlxugxohgqpsrk")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    internal fun build(): GetWebAppPrivateEndpointConnectionSlotPlainArgs =
        GetWebAppPrivateEndpointConnectionSlotPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            slot = slot ?: throw PulumiNullFieldException("slot"),
        )
}
