@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppRelayServiceConnectionSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property entityName Name of the hybrid connection.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will get a hybrid connection for the production slot.
 */
public data class GetWebAppRelayServiceConnectionSlotPlainArgs(
    public val entityName: String,
    public val name: String,
    public val resourceGroupName: String,
    public val slot: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppRelayServiceConnectionSlotPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.web.inputs.GetWebAppRelayServiceConnectionSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppRelayServiceConnectionSlotPlainArgs.builder()
            .entityName(entityName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppRelayServiceConnectionSlotPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppRelayServiceConnectionSlotPlainArgsBuilder internal constructor() {
    private var entityName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var slot: String? = null

    /**
     * @param value Name of the hybrid connection.
     */
    @JvmName("vceivpfjwilmjomy")
    public suspend fun entityName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.entityName = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("iefdlxcubepmguvt")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("dkwwutbvsuwxgimq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will get a hybrid connection for the production slot.
     */
    @JvmName("qvcycdbhkneuqmin")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    internal fun build(): GetWebAppRelayServiceConnectionSlotPlainArgs =
        GetWebAppRelayServiceConnectionSlotPlainArgs(
            entityName = entityName ?: throw PulumiNullFieldException("entityName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            slot = slot ?: throw PulumiNullFieldException("slot"),
        )
}
