@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.HostingEnvironmentProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specification for an App Service Environment to use for this resource.
 * @property id Resource ID of the App Service Environment.
 */
public data class HostingEnvironmentProfileArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.HostingEnvironmentProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.HostingEnvironmentProfileArgs =
        com.pulumi.azurenative.web.inputs.HostingEnvironmentProfileArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HostingEnvironmentProfileArgs].
 */
@PulumiTagMarker
public class HostingEnvironmentProfileArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID of the App Service Environment.
     */
    @JvmName("wrayceveuayjvlhc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID of the App Service Environment.
     */
    @JvmName("amwtfqngdmxkehdy")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): HostingEnvironmentProfileArgs = HostingEnvironmentProfileArgs(
        id = id,
    )
}
