@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.IpSecurityRestrictionArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.IpFilterTag
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * IP security restriction on an app.
 * @property action Allow or Deny access for this IP range.
 * @property description IP restriction rule description.
 * @property headers IP restriction rule headers.
 * X-Forwarded-Host (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
 * The matching logic is ..
 * - If the property is null or empty (default), all hosts(or lack of) are allowed.
 * - A value is compared using ordinal-ignore-case (excluding port number).
 * - Subdomain wildcards are permitted but don't match the root domain. For example, *.contoso.com matches the subdomain foo.contoso.com
 *  but not the root domain contoso.com or multi-level foo.bar.contoso.com
 * - Unicode host names are allowed but are converted to Punycode for matching.
 * X-Forwarded-For (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
 * The matching logic is ..
 * - If the property is null or empty (default), any forwarded-for chains (or lack of) are allowed.
 * - If any address (excluding port number) in the chain (comma separated) matches the CIDR defined by the property.
 * X-Azure-FDID and X-FD-HealthProbe.
 * The matching logic is exact match.
 * @property ipAddress IP address the security restriction is valid for.
 * It can be in form of pure ipv4 address (required SubnetMask property) or
 * CIDR notation such as ipv4/mask (leading bit match). For CIDR,
 * SubnetMask property must not be specified.
 * @property name IP restriction rule name.
 * @property priority Priority of IP restriction rule.
 * @property subnetMask Subnet mask for the range of IP addresses the restriction is valid for.
 * @property subnetTrafficTag (internal) Subnet traffic tag
 * @property tag Defines what this IP filter will be used for. This is to support IP filtering on proxies.
 * @property vnetSubnetResourceId Virtual network resource id
 * @property vnetTrafficTag (internal) Vnet traffic tag
 */
public data class IpSecurityRestrictionArgs(
    public val action: Output<String>? = null,
    public val description: Output<String>? = null,
    public val headers: Output<Map<String, List<String>>>? = null,
    public val ipAddress: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val subnetMask: Output<String>? = null,
    public val subnetTrafficTag: Output<Int>? = null,
    public val tag: Output<Either<String, IpFilterTag>>? = null,
    public val vnetSubnetResourceId: Output<String>? = null,
    public val vnetTrafficTag: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.IpSecurityRestrictionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.IpSecurityRestrictionArgs =
        com.pulumi.azurenative.web.inputs.IpSecurityRestrictionArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.map({ args0 ->
                                args0
                            }),
                        )
                    }).toMap()
                }),
            )
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .subnetMask(subnetMask?.applyValue({ args0 -> args0 }))
            .subnetTrafficTag(subnetTrafficTag?.applyValue({ args0 -> args0 }))
            .tag(
                tag?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vnetSubnetResourceId(vnetSubnetResourceId?.applyValue({ args0 -> args0 }))
            .vnetTrafficTag(vnetTrafficTag?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpSecurityRestrictionArgs].
 */
@PulumiTagMarker
public class IpSecurityRestrictionArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var description: Output<String>? = null

    private var headers: Output<Map<String, List<String>>>? = null

    private var ipAddress: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var subnetMask: Output<String>? = null

    private var subnetTrafficTag: Output<Int>? = null

    private var tag: Output<Either<String, IpFilterTag>>? = null

    private var vnetSubnetResourceId: Output<String>? = null

    private var vnetTrafficTag: Output<Int>? = null

    /**
     * @param value Allow or Deny access for this IP range.
     */
    @JvmName("gxdemmefjlaktlik")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value IP restriction rule description.
     */
    @JvmName("coebsybdiqsxqrey")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value IP restriction rule headers.
     * X-Forwarded-Host (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
     * The matching logic is ..
     * - If the property is null or empty (default), all hosts(or lack of) are allowed.
     * - A value is compared using ordinal-ignore-case (excluding port number).
     * - Subdomain wildcards are permitted but don't match the root domain. For example, *.contoso.com matches the subdomain foo.contoso.com
     *  but not the root domain contoso.com or multi-level foo.bar.contoso.com
     * - Unicode host names are allowed but are converted to Punycode for matching.
     * X-Forwarded-For (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
     * The matching logic is ..
     * - If the property is null or empty (default), any forwarded-for chains (or lack of) are allowed.
     * - If any address (excluding port number) in the chain (comma separated) matches the CIDR defined by the property.
     * X-Azure-FDID and X-FD-HealthProbe.
     * The matching logic is exact match.
     */
    @JvmName("gfibiymfqtxcxqwa")
    public suspend fun headers(`value`: Output<Map<String, List<String>>>) {
        this.headers = value
    }

    /**
     * @param value IP address the security restriction is valid for.
     * It can be in form of pure ipv4 address (required SubnetMask property) or
     * CIDR notation such as ipv4/mask (leading bit match). For CIDR,
     * SubnetMask property must not be specified.
     */
    @JvmName("ooykijvmimjxdmkf")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value IP restriction rule name.
     */
    @JvmName("kbonnqejfgsoktma")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of IP restriction rule.
     */
    @JvmName("bvdsbdrgolsqdegk")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Subnet mask for the range of IP addresses the restriction is valid for.
     */
    @JvmName("qlbmihidhutlgoyv")
    public suspend fun subnetMask(`value`: Output<String>) {
        this.subnetMask = value
    }

    /**
     * @param value (internal) Subnet traffic tag
     */
    @JvmName("igxfvqgejdtlovte")
    public suspend fun subnetTrafficTag(`value`: Output<Int>) {
        this.subnetTrafficTag = value
    }

    /**
     * @param value Defines what this IP filter will be used for. This is to support IP filtering on proxies.
     */
    @JvmName("lagpacotsgqdfhgf")
    public suspend fun tag(`value`: Output<Either<String, IpFilterTag>>) {
        this.tag = value
    }

    /**
     * @param value Virtual network resource id
     */
    @JvmName("wlhvnppwttmqktcx")
    public suspend fun vnetSubnetResourceId(`value`: Output<String>) {
        this.vnetSubnetResourceId = value
    }

    /**
     * @param value (internal) Vnet traffic tag
     */
    @JvmName("xqvceqgejahwaucr")
    public suspend fun vnetTrafficTag(`value`: Output<Int>) {
        this.vnetTrafficTag = value
    }

    /**
     * @param value Allow or Deny access for this IP range.
     */
    @JvmName("wlxvjrdeitpymrlr")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value IP restriction rule description.
     */
    @JvmName("vkgoljyattveknbk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value IP restriction rule headers.
     * X-Forwarded-Host (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
     * The matching logic is ..
     * - If the property is null or empty (default), all hosts(or lack of) are allowed.
     * - A value is compared using ordinal-ignore-case (excluding port number).
     * - Subdomain wildcards are permitted but don't match the root domain. For example, *.contoso.com matches the subdomain foo.contoso.com
     *  but not the root domain contoso.com or multi-level foo.bar.contoso.com
     * - Unicode host names are allowed but are converted to Punycode for matching.
     * X-Forwarded-For (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
     * The matching logic is ..
     * - If the property is null or empty (default), any forwarded-for chains (or lack of) are allowed.
     * - If any address (excluding port number) in the chain (comma separated) matches the CIDR defined by the property.
     * X-Azure-FDID and X-FD-HealthProbe.
     * The matching logic is exact match.
     */
    @JvmName("vwpcrwomufyxyfde")
    public suspend fun headers(`value`: Map<String, List<String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param values IP restriction rule headers.
     * X-Forwarded-Host (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
     * The matching logic is ..
     * - If the property is null or empty (default), all hosts(or lack of) are allowed.
     * - A value is compared using ordinal-ignore-case (excluding port number).
     * - Subdomain wildcards are permitted but don't match the root domain. For example, *.contoso.com matches the subdomain foo.contoso.com
     *  but not the root domain contoso.com or multi-level foo.bar.contoso.com
     * - Unicode host names are allowed but are converted to Punycode for matching.
     * X-Forwarded-For (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
     * The matching logic is ..
     * - If the property is null or empty (default), any forwarded-for chains (or lack of) are allowed.
     * - If any address (excluding port number) in the chain (comma separated) matches the CIDR defined by the property.
     * X-Azure-FDID and X-FD-HealthProbe.
     * The matching logic is exact match.
     */
    @JvmName("ltiicqqpikvjynqy")
    public fun headers(vararg values: Pair<String, List<String>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value IP address the security restriction is valid for.
     * It can be in form of pure ipv4 address (required SubnetMask property) or
     * CIDR notation such as ipv4/mask (leading bit match). For CIDR,
     * SubnetMask property must not be specified.
     */
    @JvmName("fdtaleomuaigqchh")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value IP restriction rule name.
     */
    @JvmName("bemhytrhodyttppm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of IP restriction rule.
     */
    @JvmName("kpndokbskrwdsdpq")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Subnet mask for the range of IP addresses the restriction is valid for.
     */
    @JvmName("jckbxiunbkkcodrb")
    public suspend fun subnetMask(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetMask = mapped
    }

    /**
     * @param value (internal) Subnet traffic tag
     */
    @JvmName("odtsblrhvbbhoxgb")
    public suspend fun subnetTrafficTag(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetTrafficTag = mapped
    }

    /**
     * @param value Defines what this IP filter will be used for. This is to support IP filtering on proxies.
     */
    @JvmName("ysftisdumqfyeene")
    public suspend fun tag(`value`: Either<String, IpFilterTag>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    /**
     * @param value Defines what this IP filter will be used for. This is to support IP filtering on proxies.
     */
    @JvmName("ipdfciihdgkrcbek")
    public fun tag(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IpFilterTag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    /**
     * @param value Defines what this IP filter will be used for. This is to support IP filtering on proxies.
     */
    @JvmName("lyomqarhnhrnbwhl")
    public fun tag(`value`: IpFilterTag) {
        val toBeMapped = Either.ofRight<String, IpFilterTag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    /**
     * @param value Virtual network resource id
     */
    @JvmName("ymmdwehgsmndmhda")
    public suspend fun vnetSubnetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetSubnetResourceId = mapped
    }

    /**
     * @param value (internal) Vnet traffic tag
     */
    @JvmName("llbnfxobiwkghypf")
    public suspend fun vnetTrafficTag(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetTrafficTag = mapped
    }

    internal fun build(): IpSecurityRestrictionArgs = IpSecurityRestrictionArgs(
        action = action,
        description = description,
        headers = headers,
        ipAddress = ipAddress,
        name = name,
        priority = priority,
        subnetMask = subnetMask,
        subnetTrafficTag = subnetTrafficTag,
        tag = tag,
        vnetSubnetResourceId = vnetSubnetResourceId,
        vnetTrafficTag = vnetTrafficTag,
    )
}
