@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.KubeEnvironmentProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specification for a Kubernetes Environment to use for this resource.
 * @property id Resource ID of the Kubernetes Environment.
 */
public data class KubeEnvironmentProfileArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.KubeEnvironmentProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.KubeEnvironmentProfileArgs =
        com.pulumi.azurenative.web.inputs.KubeEnvironmentProfileArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubeEnvironmentProfileArgs].
 */
@PulumiTagMarker
public class KubeEnvironmentProfileArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID of the Kubernetes Environment.
     */
    @JvmName("ephfwqjljxxticfu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID of the Kubernetes Environment.
     */
    @JvmName("adnparetckaxmieg")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): KubeEnvironmentProfileArgs = KubeEnvironmentProfileArgs(
        id = id,
    )
}
