@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ListContainerAppSecretsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the Container App.
 */
public data class ListContainerAppSecretsPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ListContainerAppSecretsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ListContainerAppSecretsPlainArgs =
        com.pulumi.azurenative.web.inputs.ListContainerAppSecretsPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListContainerAppSecretsPlainArgs].
 */
@PulumiTagMarker
public class ListContainerAppSecretsPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the Container App.
     */
    @JvmName("wtotmlxltktbraeu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): ListContainerAppSecretsPlainArgs = ListContainerAppSecretsPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
