@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ListCustomApiWsdlInterfacesPlainArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.WsdlImportMethod
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property content The WSDL content
 * @property importMethod The WSDL import method
 * @property location The location
 * @property service The service with name and endpoint names
 * @property subscriptionId Subscription Id
 * @property url The WSDL URL
 */
public data class ListCustomApiWsdlInterfacesPlainArgs(
    public val content: String? = null,
    public val importMethod: Either<String, WsdlImportMethod>? = null,
    public val location: String,
    public val service: WsdlService? = null,
    public val subscriptionId: String? = null,
    public val url: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ListCustomApiWsdlInterfacesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ListCustomApiWsdlInterfacesPlainArgs =
        com.pulumi.azurenative.web.inputs.ListCustomApiWsdlInterfacesPlainArgs.builder()
            .content(content?.let({ args0 -> args0 }))
            .importMethod(
                importMethod?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location.let({ args0 -> args0 }))
            .service(service?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subscriptionId(subscriptionId?.let({ args0 -> args0 }))
            .url(url?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListCustomApiWsdlInterfacesPlainArgs].
 */
@PulumiTagMarker
public class ListCustomApiWsdlInterfacesPlainArgsBuilder internal constructor() {
    private var content: String? = null

    private var importMethod: Either<String, WsdlImportMethod>? = null

    private var location: String? = null

    private var service: WsdlService? = null

    private var subscriptionId: String? = null

    private var url: String? = null

    /**
     * @param value The WSDL content
     */
    @JvmName("rvbhhwolphvsulmm")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.content = mapped
    }

    /**
     * @param value The WSDL import method
     */
    @JvmName("eisfilshdhesxsao")
    public suspend fun importMethod(`value`: Either<String, WsdlImportMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.importMethod = mapped
    }

    /**
     * @param value The WSDL import method
     */
    @JvmName("gwrbfekxiwtsvdhv")
    public fun importMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WsdlImportMethod>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.importMethod = mapped
    }

    /**
     * @param value The WSDL import method
     */
    @JvmName("unvgbrfyistlanaw")
    public fun importMethod(`value`: WsdlImportMethod) {
        val toBeMapped = Either.ofRight<String, WsdlImportMethod>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.importMethod = mapped
    }

    /**
     * @param value The location
     */
    @JvmName("fkrrcmhjvkgqfwyc")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.location = mapped
    }

    /**
     * @param value The service with name and endpoint names
     */
    @JvmName("mqkwlihluthpebcy")
    public suspend fun service(`value`: WsdlService?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.service = mapped
    }

    /**
     * @param argument The service with name and endpoint names
     */
    @JvmName("ftceimkvvafduwby")
    public suspend fun service(argument: suspend WsdlServiceBuilder.() -> Unit) {
        val toBeMapped = WsdlServiceBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.service = mapped
    }

    /**
     * @param value Subscription Id
     */
    @JvmName("rkswadgpkabrploe")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionId = mapped
    }

    /**
     * @param value The WSDL URL
     */
    @JvmName("imioclphnhudjouu")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.url = mapped
    }

    internal fun build(): ListCustomApiWsdlInterfacesPlainArgs = ListCustomApiWsdlInterfacesPlainArgs(
        content = content,
        importMethod = importMethod,
        location = location ?: throw PulumiNullFieldException("location"),
        service = service,
        subscriptionId = subscriptionId,
        url = url,
    )
}
