@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.RequestsBasedTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Trigger based on total requests.
 * @property count Request Count.
 * @property timeInterval Time interval.
 */
public data class RequestsBasedTriggerArgs(
    public val count: Output<Int>? = null,
    public val timeInterval: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.RequestsBasedTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.RequestsBasedTriggerArgs =
        com.pulumi.azurenative.web.inputs.RequestsBasedTriggerArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .timeInterval(timeInterval?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RequestsBasedTriggerArgs].
 */
@PulumiTagMarker
public class RequestsBasedTriggerArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var timeInterval: Output<String>? = null

    /**
     * @param value Request Count.
     */
    @JvmName("qqdoijusihuydgqv")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value Time interval.
     */
    @JvmName("vqaqgutkspjuqrat")
    public suspend fun timeInterval(`value`: Output<String>) {
        this.timeInterval = value
    }

    /**
     * @param value Request Count.
     */
    @JvmName("gwydbkcfcnpgyanr")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value Time interval.
     */
    @JvmName("cwucrgwptgcysbhq")
    public suspend fun timeInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeInterval = mapped
    }

    internal fun build(): RequestsBasedTriggerArgs = RequestsBasedTriggerArgs(
        count = count,
        timeInterval = timeInterval,
    )
}
