@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.SiteConfigArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.DefaultAction
import com.pulumi.azurenative.web.kotlin.enums.FtpsState
import com.pulumi.azurenative.web.kotlin.enums.ManagedPipelineMode
import com.pulumi.azurenative.web.kotlin.enums.ScmType
import com.pulumi.azurenative.web.kotlin.enums.SiteLoadBalancing
import com.pulumi.azurenative.web.kotlin.enums.SupportedTlsVersions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Configuration of an App Service app.
 * @property acrUseManagedIdentityCreds Flag to use Managed Identity Creds for ACR pull
 * @property acrUserManagedIdentityID If using user managed identity, the user managed identity ClientId
 * @property alwaysOn <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
 * @property apiDefinition Information about the formal API definition for the app.
 * @property apiManagementConfig Azure API management settings linked to the app.
 * @property appCommandLine App command line to launch.
 * @property appSettings Application settings.
 * @property autoHealEnabled <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
 * @property autoHealRules Auto Heal rules.
 * @property autoSwapSlotName Auto-swap slot name.
 * @property azureStorageAccounts List of Azure Storage Accounts.
 * @property connectionStrings Connection strings.
 * @property cors Cross-Origin Resource Sharing (CORS) settings.
 * @property defaultDocuments Default documents.
 * @property detailedErrorLoggingEnabled <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
 * @property documentRoot Document root.
 * @property elasticWebAppScaleLimit Maximum number of workers that a site can scale out to.
 * This setting only applies to apps in plans where ElasticScaleEnabled is <code>true</code>
 * @property experiments This is work around for polymorphic types.
 * @property ftpsState State of FTP / FTPS service
 * @property functionAppScaleLimit Maximum number of workers that a site can scale out to.
 * This setting only applies to the Consumption and Elastic Premium Plans
 * @property functionsRuntimeScaleMonitoringEnabled Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled,
 * the ScaleController will not monitor event sources directly, but will instead call to the
 * runtime to get scale status.
 * @property handlerMappings Handler mappings.
 * @property healthCheckPath Health check path
 * @property http20Enabled Http20Enabled: configures a web site to allow clients to connect over http2.0
 * @property httpLoggingEnabled <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
 * @property ipSecurityRestrictions IP security restrictions for main.
 * @property ipSecurityRestrictionsDefaultAction Default action for main access restriction if no rules are matched.
 * @property javaContainer Java container.
 * @property javaContainerVersion Java container version.
 * @property javaVersion Java version.
 * @property keyVaultReferenceIdentity Identity to use for Key Vault Reference authentication.
 * @property limits Site limits.
 * @property linuxFxVersion Linux App Framework and version
 * @property loadBalancing Site load balancing.
 * @property localMySqlEnabled <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
 * @property logsDirectorySizeLimit HTTP logs directory size limit.
 * @property managedPipelineMode Managed pipeline mode.
 * @property managedServiceIdentityId Managed Service Identity Id
 * @property metadata Application metadata. This property cannot be retrieved, since it may contain secrets.
 * @property minTlsVersion MinTlsVersion: configures the minimum version of TLS required for SSL requests
 * @property minimumElasticInstanceCount Number of minimum instance count for a site
 * This setting only applies to the Elastic Plans
 * @property netFrameworkVersion .NET Framework version.
 * @property nodeVersion Version of Node.js.
 * @property numberOfWorkers Number of workers.
 * @property phpVersion Version of PHP.
 * @property powerShellVersion Version of PowerShell.
 * @property preWarmedInstanceCount Number of preWarmed instances.
 * This setting only applies to the Consumption and Elastic Plans
 * @property publicNetworkAccess Property to allow or block all public traffic.
 * @property publishingUsername Publishing user name.
 * @property push Push endpoint settings.
 * @property pythonVersion Version of Python.
 * @property remoteDebuggingEnabled <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
 * @property remoteDebuggingVersion Remote debugging version.
 * @property requestTracingEnabled <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
 * @property requestTracingExpirationTime Request tracing expiration time.
 * @property scmIpSecurityRestrictions IP security restrictions for scm.
 * @property scmIpSecurityRestrictionsDefaultAction Default action for scm access restriction if no rules are matched.
 * @property scmIpSecurityRestrictionsUseMain IP security restrictions for scm to use main.
 * @property scmMinTlsVersion ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
 * @property scmType SCM type.
 * @property tracingOptions Tracing options.
 * @property use32BitWorkerProcess <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
 * @property virtualApplications Virtual applications.
 * @property vnetName Virtual Network name.
 * @property vnetPrivatePortsCount The number of private ports assigned to this app. These will be assigned dynamically on runtime.
 * @property vnetRouteAllEnabled Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
 * @property webSocketsEnabled <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
 * @property websiteTimeZone Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones
 * @property windowsFxVersion Xenon App Framework and version
 * @property xManagedServiceIdentityId Explicit Managed Service Identity Id
 */
public data class SiteConfigArgs(
    public val acrUseManagedIdentityCreds: Output<Boolean>? = null,
    public val acrUserManagedIdentityID: Output<String>? = null,
    public val alwaysOn: Output<Boolean>? = null,
    public val apiDefinition: Output<ApiDefinitionInfoArgs>? = null,
    public val apiManagementConfig: Output<ApiManagementConfigArgs>? = null,
    public val appCommandLine: Output<String>? = null,
    public val appSettings: Output<List<NameValuePairArgs>>? = null,
    public val autoHealEnabled: Output<Boolean>? = null,
    public val autoHealRules: Output<AutoHealRulesArgs>? = null,
    public val autoSwapSlotName: Output<String>? = null,
    public val azureStorageAccounts: Output<Map<String, AzureStorageInfoValueArgs>>? = null,
    public val connectionStrings: Output<List<ConnStringInfoArgs>>? = null,
    public val cors: Output<CorsSettingsArgs>? = null,
    public val defaultDocuments: Output<List<String>>? = null,
    public val detailedErrorLoggingEnabled: Output<Boolean>? = null,
    public val documentRoot: Output<String>? = null,
    public val elasticWebAppScaleLimit: Output<Int>? = null,
    public val experiments: Output<ExperimentsArgs>? = null,
    public val ftpsState: Output<Either<String, FtpsState>>? = null,
    public val functionAppScaleLimit: Output<Int>? = null,
    public val functionsRuntimeScaleMonitoringEnabled: Output<Boolean>? = null,
    public val handlerMappings: Output<List<HandlerMappingArgs>>? = null,
    public val healthCheckPath: Output<String>? = null,
    public val http20Enabled: Output<Boolean>? = null,
    public val httpLoggingEnabled: Output<Boolean>? = null,
    public val ipSecurityRestrictions: Output<List<IpSecurityRestrictionArgs>>? = null,
    public val ipSecurityRestrictionsDefaultAction: Output<Either<String, DefaultAction>>? = null,
    public val javaContainer: Output<String>? = null,
    public val javaContainerVersion: Output<String>? = null,
    public val javaVersion: Output<String>? = null,
    public val keyVaultReferenceIdentity: Output<String>? = null,
    public val limits: Output<SiteLimitsArgs>? = null,
    public val linuxFxVersion: Output<String>? = null,
    public val loadBalancing: Output<SiteLoadBalancing>? = null,
    public val localMySqlEnabled: Output<Boolean>? = null,
    public val logsDirectorySizeLimit: Output<Int>? = null,
    public val managedPipelineMode: Output<ManagedPipelineMode>? = null,
    public val managedServiceIdentityId: Output<Int>? = null,
    public val metadata: Output<List<NameValuePairArgs>>? = null,
    public val minTlsVersion: Output<Either<String, SupportedTlsVersions>>? = null,
    public val minimumElasticInstanceCount: Output<Int>? = null,
    public val netFrameworkVersion: Output<String>? = null,
    public val nodeVersion: Output<String>? = null,
    public val numberOfWorkers: Output<Int>? = null,
    public val phpVersion: Output<String>? = null,
    public val powerShellVersion: Output<String>? = null,
    public val preWarmedInstanceCount: Output<Int>? = null,
    public val publicNetworkAccess: Output<String>? = null,
    public val publishingUsername: Output<String>? = null,
    public val push: Output<PushSettingsArgs>? = null,
    public val pythonVersion: Output<String>? = null,
    public val remoteDebuggingEnabled: Output<Boolean>? = null,
    public val remoteDebuggingVersion: Output<String>? = null,
    public val requestTracingEnabled: Output<Boolean>? = null,
    public val requestTracingExpirationTime: Output<String>? = null,
    public val scmIpSecurityRestrictions: Output<List<IpSecurityRestrictionArgs>>? = null,
    public val scmIpSecurityRestrictionsDefaultAction: Output<Either<String, DefaultAction>>? = null,
    public val scmIpSecurityRestrictionsUseMain: Output<Boolean>? = null,
    public val scmMinTlsVersion: Output<Either<String, SupportedTlsVersions>>? = null,
    public val scmType: Output<Either<String, ScmType>>? = null,
    public val tracingOptions: Output<String>? = null,
    public val use32BitWorkerProcess: Output<Boolean>? = null,
    public val virtualApplications: Output<List<VirtualApplicationArgs>>? = null,
    public val vnetName: Output<String>? = null,
    public val vnetPrivatePortsCount: Output<Int>? = null,
    public val vnetRouteAllEnabled: Output<Boolean>? = null,
    public val webSocketsEnabled: Output<Boolean>? = null,
    public val websiteTimeZone: Output<String>? = null,
    public val windowsFxVersion: Output<String>? = null,
    public val xManagedServiceIdentityId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.SiteConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.SiteConfigArgs =
        com.pulumi.azurenative.web.inputs.SiteConfigArgs.builder()
            .acrUseManagedIdentityCreds(acrUseManagedIdentityCreds?.applyValue({ args0 -> args0 }))
            .acrUserManagedIdentityID(acrUserManagedIdentityID?.applyValue({ args0 -> args0 }))
            .alwaysOn(alwaysOn?.applyValue({ args0 -> args0 }))
            .apiDefinition(apiDefinition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .apiManagementConfig(
                apiManagementConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .appCommandLine(appCommandLine?.applyValue({ args0 -> args0 }))
            .appSettings(
                appSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .autoHealEnabled(autoHealEnabled?.applyValue({ args0 -> args0 }))
            .autoHealRules(autoHealRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .autoSwapSlotName(autoSwapSlotName?.applyValue({ args0 -> args0 }))
            .azureStorageAccounts(
                azureStorageAccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .connectionStrings(
                connectionStrings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cors(cors?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .defaultDocuments(defaultDocuments?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .detailedErrorLoggingEnabled(detailedErrorLoggingEnabled?.applyValue({ args0 -> args0 }))
            .documentRoot(documentRoot?.applyValue({ args0 -> args0 }))
            .elasticWebAppScaleLimit(elasticWebAppScaleLimit?.applyValue({ args0 -> args0 }))
            .experiments(experiments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ftpsState(
                ftpsState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .functionAppScaleLimit(functionAppScaleLimit?.applyValue({ args0 -> args0 }))
            .functionsRuntimeScaleMonitoringEnabled(
                functionsRuntimeScaleMonitoringEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .handlerMappings(
                handlerMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .healthCheckPath(healthCheckPath?.applyValue({ args0 -> args0 }))
            .http20Enabled(http20Enabled?.applyValue({ args0 -> args0 }))
            .httpLoggingEnabled(httpLoggingEnabled?.applyValue({ args0 -> args0 }))
            .ipSecurityRestrictions(
                ipSecurityRestrictions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipSecurityRestrictionsDefaultAction(
                ipSecurityRestrictionsDefaultAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .javaContainer(javaContainer?.applyValue({ args0 -> args0 }))
            .javaContainerVersion(javaContainerVersion?.applyValue({ args0 -> args0 }))
            .javaVersion(javaVersion?.applyValue({ args0 -> args0 }))
            .keyVaultReferenceIdentity(keyVaultReferenceIdentity?.applyValue({ args0 -> args0 }))
            .limits(limits?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linuxFxVersion(linuxFxVersion?.applyValue({ args0 -> args0 }))
            .loadBalancing(loadBalancing?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .localMySqlEnabled(localMySqlEnabled?.applyValue({ args0 -> args0 }))
            .logsDirectorySizeLimit(logsDirectorySizeLimit?.applyValue({ args0 -> args0 }))
            .managedPipelineMode(
                managedPipelineMode?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .managedServiceIdentityId(managedServiceIdentityId?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .minTlsVersion(
                minTlsVersion?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .minimumElasticInstanceCount(minimumElasticInstanceCount?.applyValue({ args0 -> args0 }))
            .netFrameworkVersion(netFrameworkVersion?.applyValue({ args0 -> args0 }))
            .nodeVersion(nodeVersion?.applyValue({ args0 -> args0 }))
            .numberOfWorkers(numberOfWorkers?.applyValue({ args0 -> args0 }))
            .phpVersion(phpVersion?.applyValue({ args0 -> args0 }))
            .powerShellVersion(powerShellVersion?.applyValue({ args0 -> args0 }))
            .preWarmedInstanceCount(preWarmedInstanceCount?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(publicNetworkAccess?.applyValue({ args0 -> args0 }))
            .publishingUsername(publishingUsername?.applyValue({ args0 -> args0 }))
            .push(push?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .pythonVersion(pythonVersion?.applyValue({ args0 -> args0 }))
            .remoteDebuggingEnabled(remoteDebuggingEnabled?.applyValue({ args0 -> args0 }))
            .remoteDebuggingVersion(remoteDebuggingVersion?.applyValue({ args0 -> args0 }))
            .requestTracingEnabled(requestTracingEnabled?.applyValue({ args0 -> args0 }))
            .requestTracingExpirationTime(requestTracingExpirationTime?.applyValue({ args0 -> args0 }))
            .scmIpSecurityRestrictions(
                scmIpSecurityRestrictions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .scmIpSecurityRestrictionsDefaultAction(
                scmIpSecurityRestrictionsDefaultAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .scmIpSecurityRestrictionsUseMain(scmIpSecurityRestrictionsUseMain?.applyValue({ args0 -> args0 }))
            .scmMinTlsVersion(
                scmMinTlsVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .scmType(
                scmType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tracingOptions(tracingOptions?.applyValue({ args0 -> args0 }))
            .use32BitWorkerProcess(use32BitWorkerProcess?.applyValue({ args0 -> args0 }))
            .virtualApplications(
                virtualApplications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vnetName(vnetName?.applyValue({ args0 -> args0 }))
            .vnetPrivatePortsCount(vnetPrivatePortsCount?.applyValue({ args0 -> args0 }))
            .vnetRouteAllEnabled(vnetRouteAllEnabled?.applyValue({ args0 -> args0 }))
            .webSocketsEnabled(webSocketsEnabled?.applyValue({ args0 -> args0 }))
            .websiteTimeZone(websiteTimeZone?.applyValue({ args0 -> args0 }))
            .windowsFxVersion(windowsFxVersion?.applyValue({ args0 -> args0 }))
            .xManagedServiceIdentityId(xManagedServiceIdentityId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SiteConfigArgs].
 */
@PulumiTagMarker
public class SiteConfigArgsBuilder internal constructor() {
    private var acrUseManagedIdentityCreds: Output<Boolean>? = null

    private var acrUserManagedIdentityID: Output<String>? = null

    private var alwaysOn: Output<Boolean>? = null

    private var apiDefinition: Output<ApiDefinitionInfoArgs>? = null

    private var apiManagementConfig: Output<ApiManagementConfigArgs>? = null

    private var appCommandLine: Output<String>? = null

    private var appSettings: Output<List<NameValuePairArgs>>? = null

    private var autoHealEnabled: Output<Boolean>? = null

    private var autoHealRules: Output<AutoHealRulesArgs>? = null

    private var autoSwapSlotName: Output<String>? = null

    private var azureStorageAccounts: Output<Map<String, AzureStorageInfoValueArgs>>? = null

    private var connectionStrings: Output<List<ConnStringInfoArgs>>? = null

    private var cors: Output<CorsSettingsArgs>? = null

    private var defaultDocuments: Output<List<String>>? = null

    private var detailedErrorLoggingEnabled: Output<Boolean>? = null

    private var documentRoot: Output<String>? = null

    private var elasticWebAppScaleLimit: Output<Int>? = null

    private var experiments: Output<ExperimentsArgs>? = null

    private var ftpsState: Output<Either<String, FtpsState>>? = null

    private var functionAppScaleLimit: Output<Int>? = null

    private var functionsRuntimeScaleMonitoringEnabled: Output<Boolean>? = null

    private var handlerMappings: Output<List<HandlerMappingArgs>>? = null

    private var healthCheckPath: Output<String>? = null

    private var http20Enabled: Output<Boolean>? = null

    private var httpLoggingEnabled: Output<Boolean>? = null

    private var ipSecurityRestrictions: Output<List<IpSecurityRestrictionArgs>>? = null

    private var ipSecurityRestrictionsDefaultAction: Output<Either<String, DefaultAction>>? = null

    private var javaContainer: Output<String>? = null

    private var javaContainerVersion: Output<String>? = null

    private var javaVersion: Output<String>? = null

    private var keyVaultReferenceIdentity: Output<String>? = null

    private var limits: Output<SiteLimitsArgs>? = null

    private var linuxFxVersion: Output<String>? = null

    private var loadBalancing: Output<SiteLoadBalancing>? = null

    private var localMySqlEnabled: Output<Boolean>? = null

    private var logsDirectorySizeLimit: Output<Int>? = null

    private var managedPipelineMode: Output<ManagedPipelineMode>? = null

    private var managedServiceIdentityId: Output<Int>? = null

    private var metadata: Output<List<NameValuePairArgs>>? = null

    private var minTlsVersion: Output<Either<String, SupportedTlsVersions>>? = null

    private var minimumElasticInstanceCount: Output<Int>? = null

    private var netFrameworkVersion: Output<String>? = null

    private var nodeVersion: Output<String>? = null

    private var numberOfWorkers: Output<Int>? = null

    private var phpVersion: Output<String>? = null

    private var powerShellVersion: Output<String>? = null

    private var preWarmedInstanceCount: Output<Int>? = null

    private var publicNetworkAccess: Output<String>? = null

    private var publishingUsername: Output<String>? = null

    private var push: Output<PushSettingsArgs>? = null

    private var pythonVersion: Output<String>? = null

    private var remoteDebuggingEnabled: Output<Boolean>? = null

    private var remoteDebuggingVersion: Output<String>? = null

    private var requestTracingEnabled: Output<Boolean>? = null

    private var requestTracingExpirationTime: Output<String>? = null

    private var scmIpSecurityRestrictions: Output<List<IpSecurityRestrictionArgs>>? = null

    private var scmIpSecurityRestrictionsDefaultAction: Output<Either<String, DefaultAction>>? = null

    private var scmIpSecurityRestrictionsUseMain: Output<Boolean>? = null

    private var scmMinTlsVersion: Output<Either<String, SupportedTlsVersions>>? = null

    private var scmType: Output<Either<String, ScmType>>? = null

    private var tracingOptions: Output<String>? = null

    private var use32BitWorkerProcess: Output<Boolean>? = null

    private var virtualApplications: Output<List<VirtualApplicationArgs>>? = null

    private var vnetName: Output<String>? = null

    private var vnetPrivatePortsCount: Output<Int>? = null

    private var vnetRouteAllEnabled: Output<Boolean>? = null

    private var webSocketsEnabled: Output<Boolean>? = null

    private var websiteTimeZone: Output<String>? = null

    private var windowsFxVersion: Output<String>? = null

    private var xManagedServiceIdentityId: Output<Int>? = null

    /**
     * @param value Flag to use Managed Identity Creds for ACR pull
     */
    @JvmName("rnqpssgpdldhpbnd")
    public suspend fun acrUseManagedIdentityCreds(`value`: Output<Boolean>) {
        this.acrUseManagedIdentityCreds = value
    }

    /**
     * @param value If using user managed identity, the user managed identity ClientId
     */
    @JvmName("rgjuyumtdhrcxqbv")
    public suspend fun acrUserManagedIdentityID(`value`: Output<String>) {
        this.acrUserManagedIdentityID = value
    }

    /**
     * @param value <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
     */
    @JvmName("aegfydflcvstbvhs")
    public suspend fun alwaysOn(`value`: Output<Boolean>) {
        this.alwaysOn = value
    }

    /**
     * @param value Information about the formal API definition for the app.
     */
    @JvmName("tcmapmdjhtfcsnng")
    public suspend fun apiDefinition(`value`: Output<ApiDefinitionInfoArgs>) {
        this.apiDefinition = value
    }

    /**
     * @param value Azure API management settings linked to the app.
     */
    @JvmName("srvblbgceyvongpm")
    public suspend fun apiManagementConfig(`value`: Output<ApiManagementConfigArgs>) {
        this.apiManagementConfig = value
    }

    /**
     * @param value App command line to launch.
     */
    @JvmName("avqbivaqmwnslqxu")
    public suspend fun appCommandLine(`value`: Output<String>) {
        this.appCommandLine = value
    }

    /**
     * @param value Application settings.
     */
    @JvmName("hadxpuhsplffvfek")
    public suspend fun appSettings(`value`: Output<List<NameValuePairArgs>>) {
        this.appSettings = value
    }

    @JvmName("ftidnqmiyrtcknvn")
    public suspend fun appSettings(vararg values: Output<NameValuePairArgs>) {
        this.appSettings = Output.all(values.asList())
    }

    /**
     * @param values Application settings.
     */
    @JvmName("fjrmnlptepcdnjos")
    public suspend fun appSettings(values: List<Output<NameValuePairArgs>>) {
        this.appSettings = Output.all(values)
    }

    /**
     * @param value <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
     */
    @JvmName("jkpwifcgvmwynxuk")
    public suspend fun autoHealEnabled(`value`: Output<Boolean>) {
        this.autoHealEnabled = value
    }

    /**
     * @param value Auto Heal rules.
     */
    @JvmName("esocscrgqjxuggkv")
    public suspend fun autoHealRules(`value`: Output<AutoHealRulesArgs>) {
        this.autoHealRules = value
    }

    /**
     * @param value Auto-swap slot name.
     */
    @JvmName("iahdhbclynubbrfw")
    public suspend fun autoSwapSlotName(`value`: Output<String>) {
        this.autoSwapSlotName = value
    }

    /**
     * @param value List of Azure Storage Accounts.
     */
    @JvmName("btmwokqwrlcfityy")
    public suspend fun azureStorageAccounts(`value`: Output<Map<String, AzureStorageInfoValueArgs>>) {
        this.azureStorageAccounts = value
    }

    /**
     * @param value Connection strings.
     */
    @JvmName("cxipvokrwruxunyn")
    public suspend fun connectionStrings(`value`: Output<List<ConnStringInfoArgs>>) {
        this.connectionStrings = value
    }

    @JvmName("gkmwclylhmiresbj")
    public suspend fun connectionStrings(vararg values: Output<ConnStringInfoArgs>) {
        this.connectionStrings = Output.all(values.asList())
    }

    /**
     * @param values Connection strings.
     */
    @JvmName("xgxawmsrdkipwsbi")
    public suspend fun connectionStrings(values: List<Output<ConnStringInfoArgs>>) {
        this.connectionStrings = Output.all(values)
    }

    /**
     * @param value Cross-Origin Resource Sharing (CORS) settings.
     */
    @JvmName("ikmeopgkdughroyl")
    public suspend fun cors(`value`: Output<CorsSettingsArgs>) {
        this.cors = value
    }

    /**
     * @param value Default documents.
     */
    @JvmName("ysbstnsfmkplyhlc")
    public suspend fun defaultDocuments(`value`: Output<List<String>>) {
        this.defaultDocuments = value
    }

    @JvmName("krpfsxxleoowyfcy")
    public suspend fun defaultDocuments(vararg values: Output<String>) {
        this.defaultDocuments = Output.all(values.asList())
    }

    /**
     * @param values Default documents.
     */
    @JvmName("vnhagehvkjaaqpyt")
    public suspend fun defaultDocuments(values: List<Output<String>>) {
        this.defaultDocuments = Output.all(values)
    }

    /**
     * @param value <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
     */
    @JvmName("hjjvjlbvurldedul")
    public suspend fun detailedErrorLoggingEnabled(`value`: Output<Boolean>) {
        this.detailedErrorLoggingEnabled = value
    }

    /**
     * @param value Document root.
     */
    @JvmName("onjevdaagmroliyg")
    public suspend fun documentRoot(`value`: Output<String>) {
        this.documentRoot = value
    }

    /**
     * @param value Maximum number of workers that a site can scale out to.
     * This setting only applies to apps in plans where ElasticScaleEnabled is <code>true</code>
     */
    @JvmName("fffcyftkmgaaortv")
    public suspend fun elasticWebAppScaleLimit(`value`: Output<Int>) {
        this.elasticWebAppScaleLimit = value
    }

    /**
     * @param value This is work around for polymorphic types.
     */
    @JvmName("fyrbdcjycrldmdmr")
    public suspend fun experiments(`value`: Output<ExperimentsArgs>) {
        this.experiments = value
    }

    /**
     * @param value State of FTP / FTPS service
     */
    @JvmName("yarncvoetqqjeaek")
    public suspend fun ftpsState(`value`: Output<Either<String, FtpsState>>) {
        this.ftpsState = value
    }

    /**
     * @param value Maximum number of workers that a site can scale out to.
     * This setting only applies to the Consumption and Elastic Premium Plans
     */
    @JvmName("wrelrwnaosxnwmbu")
    public suspend fun functionAppScaleLimit(`value`: Output<Int>) {
        this.functionAppScaleLimit = value
    }

    /**
     * @param value Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled,
     * the ScaleController will not monitor event sources directly, but will instead call to the
     * runtime to get scale status.
     */
    @JvmName("bmgauclkaaxliidx")
    public suspend fun functionsRuntimeScaleMonitoringEnabled(`value`: Output<Boolean>) {
        this.functionsRuntimeScaleMonitoringEnabled = value
    }

    /**
     * @param value Handler mappings.
     */
    @JvmName("bwtifiaswcqmpvxu")
    public suspend fun handlerMappings(`value`: Output<List<HandlerMappingArgs>>) {
        this.handlerMappings = value
    }

    @JvmName("mfxqmekwynxrbwnt")
    public suspend fun handlerMappings(vararg values: Output<HandlerMappingArgs>) {
        this.handlerMappings = Output.all(values.asList())
    }

    /**
     * @param values Handler mappings.
     */
    @JvmName("bwdelricuvatidaq")
    public suspend fun handlerMappings(values: List<Output<HandlerMappingArgs>>) {
        this.handlerMappings = Output.all(values)
    }

    /**
     * @param value Health check path
     */
    @JvmName("jnuiufneteurhtbn")
    public suspend fun healthCheckPath(`value`: Output<String>) {
        this.healthCheckPath = value
    }

    /**
     * @param value Http20Enabled: configures a web site to allow clients to connect over http2.0
     */
    @JvmName("tbwuqedpnbpwtybk")
    public suspend fun http20Enabled(`value`: Output<Boolean>) {
        this.http20Enabled = value
    }

    /**
     * @param value <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
     */
    @JvmName("otvsyyomlpisckfe")
    public suspend fun httpLoggingEnabled(`value`: Output<Boolean>) {
        this.httpLoggingEnabled = value
    }

    /**
     * @param value IP security restrictions for main.
     */
    @JvmName("dudjgckrcpiecnpr")
    public suspend fun ipSecurityRestrictions(`value`: Output<List<IpSecurityRestrictionArgs>>) {
        this.ipSecurityRestrictions = value
    }

    @JvmName("mbygjsxedqsydnrh")
    public suspend fun ipSecurityRestrictions(vararg values: Output<IpSecurityRestrictionArgs>) {
        this.ipSecurityRestrictions = Output.all(values.asList())
    }

    /**
     * @param values IP security restrictions for main.
     */
    @JvmName("vpstgqnqnhxnqaxp")
    public suspend fun ipSecurityRestrictions(values: List<Output<IpSecurityRestrictionArgs>>) {
        this.ipSecurityRestrictions = Output.all(values)
    }

    /**
     * @param value Default action for main access restriction if no rules are matched.
     */
    @JvmName("jmchsvtrivfltgnr")
    public suspend
    fun ipSecurityRestrictionsDefaultAction(`value`: Output<Either<String, DefaultAction>>) {
        this.ipSecurityRestrictionsDefaultAction = value
    }

    /**
     * @param value Java container.
     */
    @JvmName("qowyyulbqsjfrhsl")
    public suspend fun javaContainer(`value`: Output<String>) {
        this.javaContainer = value
    }

    /**
     * @param value Java container version.
     */
    @JvmName("bihturnhbuqwnibr")
    public suspend fun javaContainerVersion(`value`: Output<String>) {
        this.javaContainerVersion = value
    }

    /**
     * @param value Java version.
     */
    @JvmName("tglevplepachatkg")
    public suspend fun javaVersion(`value`: Output<String>) {
        this.javaVersion = value
    }

    /**
     * @param value Identity to use for Key Vault Reference authentication.
     */
    @JvmName("yttsbyfifcyiytac")
    public suspend fun keyVaultReferenceIdentity(`value`: Output<String>) {
        this.keyVaultReferenceIdentity = value
    }

    /**
     * @param value Site limits.
     */
    @JvmName("rbxgwlsnhcufocsa")
    public suspend fun limits(`value`: Output<SiteLimitsArgs>) {
        this.limits = value
    }

    /**
     * @param value Linux App Framework and version
     */
    @JvmName("iniwfsravwutcffl")
    public suspend fun linuxFxVersion(`value`: Output<String>) {
        this.linuxFxVersion = value
    }

    /**
     * @param value Site load balancing.
     */
    @JvmName("pcwrpbfxfggfglhc")
    public suspend fun loadBalancing(`value`: Output<SiteLoadBalancing>) {
        this.loadBalancing = value
    }

    /**
     * @param value <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
     */
    @JvmName("nsscybxcxtvpgdlp")
    public suspend fun localMySqlEnabled(`value`: Output<Boolean>) {
        this.localMySqlEnabled = value
    }

    /**
     * @param value HTTP logs directory size limit.
     */
    @JvmName("fleikntslufkhcuj")
    public suspend fun logsDirectorySizeLimit(`value`: Output<Int>) {
        this.logsDirectorySizeLimit = value
    }

    /**
     * @param value Managed pipeline mode.
     */
    @JvmName("bucwomxqycthmqou")
    public suspend fun managedPipelineMode(`value`: Output<ManagedPipelineMode>) {
        this.managedPipelineMode = value
    }

    /**
     * @param value Managed Service Identity Id
     */
    @JvmName("njqejbelykplequh")
    public suspend fun managedServiceIdentityId(`value`: Output<Int>) {
        this.managedServiceIdentityId = value
    }

    /**
     * @param value Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("ffjhucbcesgglmid")
    public suspend fun metadata(`value`: Output<List<NameValuePairArgs>>) {
        this.metadata = value
    }

    @JvmName("bayvowdnhbuturtr")
    public suspend fun metadata(vararg values: Output<NameValuePairArgs>) {
        this.metadata = Output.all(values.asList())
    }

    /**
     * @param values Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("yqjcybbccxfduyrg")
    public suspend fun metadata(values: List<Output<NameValuePairArgs>>) {
        this.metadata = Output.all(values)
    }

    /**
     * @param value MinTlsVersion: configures the minimum version of TLS required for SSL requests
     */
    @JvmName("iktqfrcxakkimdfp")
    public suspend fun minTlsVersion(`value`: Output<Either<String, SupportedTlsVersions>>) {
        this.minTlsVersion = value
    }

    /**
     * @param value Number of minimum instance count for a site
     * This setting only applies to the Elastic Plans
     */
    @JvmName("mrkdukxlvecshdsm")
    public suspend fun minimumElasticInstanceCount(`value`: Output<Int>) {
        this.minimumElasticInstanceCount = value
    }

    /**
     * @param value .NET Framework version.
     */
    @JvmName("nerqodburbdprdmk")
    public suspend fun netFrameworkVersion(`value`: Output<String>) {
        this.netFrameworkVersion = value
    }

    /**
     * @param value Version of Node.js.
     */
    @JvmName("iuojbtgoubcnvnja")
    public suspend fun nodeVersion(`value`: Output<String>) {
        this.nodeVersion = value
    }

    /**
     * @param value Number of workers.
     */
    @JvmName("waponaqnbysivksb")
    public suspend fun numberOfWorkers(`value`: Output<Int>) {
        this.numberOfWorkers = value
    }

    /**
     * @param value Version of PHP.
     */
    @JvmName("kkwakswwtovyamhe")
    public suspend fun phpVersion(`value`: Output<String>) {
        this.phpVersion = value
    }

    /**
     * @param value Version of PowerShell.
     */
    @JvmName("sekyrfdxqfmqndwv")
    public suspend fun powerShellVersion(`value`: Output<String>) {
        this.powerShellVersion = value
    }

    /**
     * @param value Number of preWarmed instances.
     * This setting only applies to the Consumption and Elastic Plans
     */
    @JvmName("moinrcyxfvqukjir")
    public suspend fun preWarmedInstanceCount(`value`: Output<Int>) {
        this.preWarmedInstanceCount = value
    }

    /**
     * @param value Property to allow or block all public traffic.
     */
    @JvmName("nyshrvgjrankhgmx")
    public suspend fun publicNetworkAccess(`value`: Output<String>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Publishing user name.
     */
    @JvmName("wglnndcavhdugprv")
    public suspend fun publishingUsername(`value`: Output<String>) {
        this.publishingUsername = value
    }

    /**
     * @param value Push endpoint settings.
     */
    @JvmName("qcphoqciuyiprtkw")
    public suspend fun push(`value`: Output<PushSettingsArgs>) {
        this.push = value
    }

    /**
     * @param value Version of Python.
     */
    @JvmName("jnupowlppgdkirvt")
    public suspend fun pythonVersion(`value`: Output<String>) {
        this.pythonVersion = value
    }

    /**
     * @param value <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
     */
    @JvmName("xclucxbpabfmvska")
    public suspend fun remoteDebuggingEnabled(`value`: Output<Boolean>) {
        this.remoteDebuggingEnabled = value
    }

    /**
     * @param value Remote debugging version.
     */
    @JvmName("sxdjrhubwkjkagng")
    public suspend fun remoteDebuggingVersion(`value`: Output<String>) {
        this.remoteDebuggingVersion = value
    }

    /**
     * @param value <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
     */
    @JvmName("daqnfvogcqflhkqc")
    public suspend fun requestTracingEnabled(`value`: Output<Boolean>) {
        this.requestTracingEnabled = value
    }

    /**
     * @param value Request tracing expiration time.
     */
    @JvmName("voykqxigwgkyxkxd")
    public suspend fun requestTracingExpirationTime(`value`: Output<String>) {
        this.requestTracingExpirationTime = value
    }

    /**
     * @param value IP security restrictions for scm.
     */
    @JvmName("tfocjfutgfhggrla")
    public suspend fun scmIpSecurityRestrictions(`value`: Output<List<IpSecurityRestrictionArgs>>) {
        this.scmIpSecurityRestrictions = value
    }

    @JvmName("cdnbrlyekvmitmxa")
    public suspend fun scmIpSecurityRestrictions(vararg values: Output<IpSecurityRestrictionArgs>) {
        this.scmIpSecurityRestrictions = Output.all(values.asList())
    }

    /**
     * @param values IP security restrictions for scm.
     */
    @JvmName("kaiepxfgdyroiusj")
    public suspend fun scmIpSecurityRestrictions(values: List<Output<IpSecurityRestrictionArgs>>) {
        this.scmIpSecurityRestrictions = Output.all(values)
    }

    /**
     * @param value Default action for scm access restriction if no rules are matched.
     */
    @JvmName("tfpakhosuyyyhpff")
    public suspend
    fun scmIpSecurityRestrictionsDefaultAction(`value`: Output<Either<String, DefaultAction>>) {
        this.scmIpSecurityRestrictionsDefaultAction = value
    }

    /**
     * @param value IP security restrictions for scm to use main.
     */
    @JvmName("qysyedtqnwdnvsjv")
    public suspend fun scmIpSecurityRestrictionsUseMain(`value`: Output<Boolean>) {
        this.scmIpSecurityRestrictionsUseMain = value
    }

    /**
     * @param value ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
     */
    @JvmName("eoicdtyxjjydcxxy")
    public suspend fun scmMinTlsVersion(`value`: Output<Either<String, SupportedTlsVersions>>) {
        this.scmMinTlsVersion = value
    }

    /**
     * @param value SCM type.
     */
    @JvmName("aytywghybwtnaiwi")
    public suspend fun scmType(`value`: Output<Either<String, ScmType>>) {
        this.scmType = value
    }

    /**
     * @param value Tracing options.
     */
    @JvmName("hoiudwcepjberreo")
    public suspend fun tracingOptions(`value`: Output<String>) {
        this.tracingOptions = value
    }

    /**
     * @param value <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
     */
    @JvmName("jqxecbxemyqnphnh")
    public suspend fun use32BitWorkerProcess(`value`: Output<Boolean>) {
        this.use32BitWorkerProcess = value
    }

    /**
     * @param value Virtual applications.
     */
    @JvmName("xiiespvbhwkpghkh")
    public suspend fun virtualApplications(`value`: Output<List<VirtualApplicationArgs>>) {
        this.virtualApplications = value
    }

    @JvmName("ghlthgclvybkeili")
    public suspend fun virtualApplications(vararg values: Output<VirtualApplicationArgs>) {
        this.virtualApplications = Output.all(values.asList())
    }

    /**
     * @param values Virtual applications.
     */
    @JvmName("pspxqtequuyfaipl")
    public suspend fun virtualApplications(values: List<Output<VirtualApplicationArgs>>) {
        this.virtualApplications = Output.all(values)
    }

    /**
     * @param value Virtual Network name.
     */
    @JvmName("kdborengurhgnlvo")
    public suspend fun vnetName(`value`: Output<String>) {
        this.vnetName = value
    }

    /**
     * @param value The number of private ports assigned to this app. These will be assigned dynamically on runtime.
     */
    @JvmName("lisgsrmmxakhmqhp")
    public suspend fun vnetPrivatePortsCount(`value`: Output<Int>) {
        this.vnetPrivatePortsCount = value
    }

    /**
     * @param value Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
     */
    @JvmName("pqxcnbdclaluuhws")
    public suspend fun vnetRouteAllEnabled(`value`: Output<Boolean>) {
        this.vnetRouteAllEnabled = value
    }

    /**
     * @param value <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
     */
    @JvmName("qnxocinbkkhdkklk")
    public suspend fun webSocketsEnabled(`value`: Output<Boolean>) {
        this.webSocketsEnabled = value
    }

    /**
     * @param value Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones
     */
    @JvmName("ndovnliceemrbwvu")
    public suspend fun websiteTimeZone(`value`: Output<String>) {
        this.websiteTimeZone = value
    }

    /**
     * @param value Xenon App Framework and version
     */
    @JvmName("rudgbfhtmkbaiosd")
    public suspend fun windowsFxVersion(`value`: Output<String>) {
        this.windowsFxVersion = value
    }

    /**
     * @param value Explicit Managed Service Identity Id
     */
    @JvmName("bccvynwjfgsegdxo")
    public suspend fun xManagedServiceIdentityId(`value`: Output<Int>) {
        this.xManagedServiceIdentityId = value
    }

    /**
     * @param value Flag to use Managed Identity Creds for ACR pull
     */
    @JvmName("xdodggajfflocxvw")
    public suspend fun acrUseManagedIdentityCreds(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrUseManagedIdentityCreds = mapped
    }

    /**
     * @param value If using user managed identity, the user managed identity ClientId
     */
    @JvmName("bumjkbmigyecuqal")
    public suspend fun acrUserManagedIdentityID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrUserManagedIdentityID = mapped
    }

    /**
     * @param value <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
     */
    @JvmName("mrkcyomhlsnsphwd")
    public suspend fun alwaysOn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alwaysOn = mapped
    }

    /**
     * @param value Information about the formal API definition for the app.
     */
    @JvmName("ioscgvsqoryltpib")
    public suspend fun apiDefinition(`value`: ApiDefinitionInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiDefinition = mapped
    }

    /**
     * @param argument Information about the formal API definition for the app.
     */
    @JvmName("prjgkpftumsqxbic")
    public suspend fun apiDefinition(argument: suspend ApiDefinitionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ApiDefinitionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiDefinition = mapped
    }

    /**
     * @param value Azure API management settings linked to the app.
     */
    @JvmName("jgchjcpptvlktqsq")
    public suspend fun apiManagementConfig(`value`: ApiManagementConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiManagementConfig = mapped
    }

    /**
     * @param argument Azure API management settings linked to the app.
     */
    @JvmName("qnovjhkxnxowvcpy")
    public suspend
    fun apiManagementConfig(argument: suspend ApiManagementConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ApiManagementConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiManagementConfig = mapped
    }

    /**
     * @param value App command line to launch.
     */
    @JvmName("jxkjcvggfuftstki")
    public suspend fun appCommandLine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appCommandLine = mapped
    }

    /**
     * @param value Application settings.
     */
    @JvmName("wnydmmldthwlmiws")
    public suspend fun appSettings(`value`: List<NameValuePairArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSettings = mapped
    }

    /**
     * @param argument Application settings.
     */
    @JvmName("yothyncdddbywsqu")
    public suspend fun appSettings(argument: List<suspend NameValuePairArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NameValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.appSettings = mapped
    }

    /**
     * @param argument Application settings.
     */
    @JvmName("gwpvhdfctmfjiklp")
    public suspend fun appSettings(vararg argument: suspend NameValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NameValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.appSettings = mapped
    }

    /**
     * @param argument Application settings.
     */
    @JvmName("voetqqrtqilnomxc")
    public suspend fun appSettings(argument: suspend NameValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NameValuePairArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.appSettings = mapped
    }

    /**
     * @param values Application settings.
     */
    @JvmName("ubotpslfqpeouepf")
    public suspend fun appSettings(vararg values: NameValuePairArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appSettings = mapped
    }

    /**
     * @param value <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
     */
    @JvmName("ixaaxkihnjtoyjca")
    public suspend fun autoHealEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoHealEnabled = mapped
    }

    /**
     * @param value Auto Heal rules.
     */
    @JvmName("jtyephkijeckvann")
    public suspend fun autoHealRules(`value`: AutoHealRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoHealRules = mapped
    }

    /**
     * @param argument Auto Heal rules.
     */
    @JvmName("pxyxicnosmeedebo")
    public suspend fun autoHealRules(argument: suspend AutoHealRulesArgsBuilder.() -> Unit) {
        val toBeMapped = AutoHealRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoHealRules = mapped
    }

    /**
     * @param value Auto-swap slot name.
     */
    @JvmName("nihgbfidcwstksjg")
    public suspend fun autoSwapSlotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoSwapSlotName = mapped
    }

    /**
     * @param value List of Azure Storage Accounts.
     */
    @JvmName("radatbnfgwlwjfjb")
    public suspend fun azureStorageAccounts(`value`: Map<String, AzureStorageInfoValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureStorageAccounts = mapped
    }

    /**
     * @param argument List of Azure Storage Accounts.
     */
    @JvmName("dsbeltmtxwlphwpn")
    public suspend fun azureStorageAccounts(
        vararg
        argument: Pair<String, suspend AzureStorageInfoValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                AzureStorageInfoValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.azureStorageAccounts = mapped
    }

    /**
     * @param values List of Azure Storage Accounts.
     */
    @JvmName("lqriufdjoxnlievw")
    public fun azureStorageAccounts(vararg values: Pair<String, AzureStorageInfoValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureStorageAccounts = mapped
    }

    /**
     * @param value Connection strings.
     */
    @JvmName("owasycijhdrsvwho")
    public suspend fun connectionStrings(`value`: List<ConnStringInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionStrings = mapped
    }

    /**
     * @param argument Connection strings.
     */
    @JvmName("mxredfllakiyenhy")
    public suspend
    fun connectionStrings(argument: List<suspend ConnStringInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnStringInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectionStrings = mapped
    }

    /**
     * @param argument Connection strings.
     */
    @JvmName("xqjhmjeodvfemnmi")
    public suspend fun connectionStrings(
        vararg
        argument: suspend ConnStringInfoArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConnStringInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectionStrings = mapped
    }

    /**
     * @param argument Connection strings.
     */
    @JvmName("gcqrincvfbrsaljp")
    public suspend fun connectionStrings(argument: suspend ConnStringInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ConnStringInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.connectionStrings = mapped
    }

    /**
     * @param values Connection strings.
     */
    @JvmName("mjrichsakykvlcbc")
    public suspend fun connectionStrings(vararg values: ConnStringInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionStrings = mapped
    }

    /**
     * @param value Cross-Origin Resource Sharing (CORS) settings.
     */
    @JvmName("xwbfdmuueqoihdsv")
    public suspend fun cors(`value`: CorsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cors = mapped
    }

    /**
     * @param argument Cross-Origin Resource Sharing (CORS) settings.
     */
    @JvmName("weobiabuhdmtatqw")
    public suspend fun cors(argument: suspend CorsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CorsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param value Default documents.
     */
    @JvmName("ajrpbuacewwcddnf")
    public suspend fun defaultDocuments(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultDocuments = mapped
    }

    /**
     * @param values Default documents.
     */
    @JvmName("khrxvtssrbwupuci")
    public suspend fun defaultDocuments(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultDocuments = mapped
    }

    /**
     * @param value <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
     */
    @JvmName("nnitbnibimodfwgl")
    public suspend fun detailedErrorLoggingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detailedErrorLoggingEnabled = mapped
    }

    /**
     * @param value Document root.
     */
    @JvmName("juthiijqtfqybrem")
    public suspend fun documentRoot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentRoot = mapped
    }

    /**
     * @param value Maximum number of workers that a site can scale out to.
     * This setting only applies to apps in plans where ElasticScaleEnabled is <code>true</code>
     */
    @JvmName("owflqrurfowbmckg")
    public suspend fun elasticWebAppScaleLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticWebAppScaleLimit = mapped
    }

    /**
     * @param value This is work around for polymorphic types.
     */
    @JvmName("faxmubrwpnfveqxq")
    public suspend fun experiments(`value`: ExperimentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experiments = mapped
    }

    /**
     * @param argument This is work around for polymorphic types.
     */
    @JvmName("vtayahlwtkcmumig")
    public suspend fun experiments(argument: suspend ExperimentsArgsBuilder.() -> Unit) {
        val toBeMapped = ExperimentsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.experiments = mapped
    }

    /**
     * @param value State of FTP / FTPS service
     */
    @JvmName("vdcmiiexgraonrpc")
    public suspend fun ftpsState(`value`: Either<String, FtpsState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ftpsState = mapped
    }

    /**
     * @param value State of FTP / FTPS service
     */
    @JvmName("iedmupuucbmuoheg")
    public fun ftpsState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FtpsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ftpsState = mapped
    }

    /**
     * @param value State of FTP / FTPS service
     */
    @JvmName("aggftfvubnvobies")
    public fun ftpsState(`value`: FtpsState) {
        val toBeMapped = Either.ofRight<String, FtpsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ftpsState = mapped
    }

    /**
     * @param value Maximum number of workers that a site can scale out to.
     * This setting only applies to the Consumption and Elastic Premium Plans
     */
    @JvmName("ekttjtpnvoyyiywu")
    public suspend fun functionAppScaleLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionAppScaleLimit = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled,
     * the ScaleController will not monitor event sources directly, but will instead call to the
     * runtime to get scale status.
     */
    @JvmName("ibydxfmepynoeatt")
    public suspend fun functionsRuntimeScaleMonitoringEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionsRuntimeScaleMonitoringEnabled = mapped
    }

    /**
     * @param value Handler mappings.
     */
    @JvmName("gfakivhkuwrnkygb")
    public suspend fun handlerMappings(`value`: List<HandlerMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.handlerMappings = mapped
    }

    /**
     * @param argument Handler mappings.
     */
    @JvmName("wugknshxulpccvnj")
    public suspend fun handlerMappings(argument: List<suspend HandlerMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HandlerMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.handlerMappings = mapped
    }

    /**
     * @param argument Handler mappings.
     */
    @JvmName("jqkgyuinwpflhjwj")
    public suspend fun handlerMappings(
        vararg
        argument: suspend HandlerMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            HandlerMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.handlerMappings = mapped
    }

    /**
     * @param argument Handler mappings.
     */
    @JvmName("nkdsasnlsvuqctqu")
    public suspend fun handlerMappings(argument: suspend HandlerMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HandlerMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.handlerMappings = mapped
    }

    /**
     * @param values Handler mappings.
     */
    @JvmName("hsxipqtedeywkvnn")
    public suspend fun handlerMappings(vararg values: HandlerMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.handlerMappings = mapped
    }

    /**
     * @param value Health check path
     */
    @JvmName("xkooqrifgbcdfpsa")
    public suspend fun healthCheckPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckPath = mapped
    }

    /**
     * @param value Http20Enabled: configures a web site to allow clients to connect over http2.0
     */
    @JvmName("qugvksxemauimudx")
    public suspend fun http20Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http20Enabled = mapped
    }

    /**
     * @param value <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
     */
    @JvmName("birkfjescqkjfpsk")
    public suspend fun httpLoggingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpLoggingEnabled = mapped
    }

    /**
     * @param value IP security restrictions for main.
     */
    @JvmName("qedkynatjuisbibf")
    public suspend fun ipSecurityRestrictions(`value`: List<IpSecurityRestrictionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param argument IP security restrictions for main.
     */
    @JvmName("vxvlkyktpiyrubce")
    public suspend
    fun ipSecurityRestrictions(argument: List<suspend IpSecurityRestrictionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpSecurityRestrictionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param argument IP security restrictions for main.
     */
    @JvmName("pgtmbafukwycxkox")
    public suspend fun ipSecurityRestrictions(
        vararg
        argument: suspend IpSecurityRestrictionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IpSecurityRestrictionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param argument IP security restrictions for main.
     */
    @JvmName("grfbaqisokvbvyca")
    public suspend
    fun ipSecurityRestrictions(argument: suspend IpSecurityRestrictionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpSecurityRestrictionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param values IP security restrictions for main.
     */
    @JvmName("waiuaumscswdawiw")
    public suspend fun ipSecurityRestrictions(vararg values: IpSecurityRestrictionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param value Default action for main access restriction if no rules are matched.
     */
    @JvmName("puddjfchcoepdkgm")
    public suspend fun ipSecurityRestrictionsDefaultAction(`value`: Either<String, DefaultAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSecurityRestrictionsDefaultAction = mapped
    }

    /**
     * @param value Default action for main access restriction if no rules are matched.
     */
    @JvmName("ayxfqkyhrniqgdel")
    public fun ipSecurityRestrictionsDefaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSecurityRestrictionsDefaultAction = mapped
    }

    /**
     * @param value Default action for main access restriction if no rules are matched.
     */
    @JvmName("rkmaeokmwbjxkspd")
    public fun ipSecurityRestrictionsDefaultAction(`value`: DefaultAction) {
        val toBeMapped = Either.ofRight<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSecurityRestrictionsDefaultAction = mapped
    }

    /**
     * @param value Java container.
     */
    @JvmName("klslemlppapnsftc")
    public suspend fun javaContainer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.javaContainer = mapped
    }

    /**
     * @param value Java container version.
     */
    @JvmName("svrbyhtqvdvceniq")
    public suspend fun javaContainerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.javaContainerVersion = mapped
    }

    /**
     * @param value Java version.
     */
    @JvmName("wdlcgooegbepoffy")
    public suspend fun javaVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.javaVersion = mapped
    }

    /**
     * @param value Identity to use for Key Vault Reference authentication.
     */
    @JvmName("osuwauyterpuldph")
    public suspend fun keyVaultReferenceIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultReferenceIdentity = mapped
    }

    /**
     * @param value Site limits.
     */
    @JvmName("wlskjpnpewiloweb")
    public suspend fun limits(`value`: SiteLimitsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param argument Site limits.
     */
    @JvmName("akochqeegltifkpj")
    public suspend fun limits(argument: suspend SiteLimitsArgsBuilder.() -> Unit) {
        val toBeMapped = SiteLimitsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limits = mapped
    }

    /**
     * @param value Linux App Framework and version
     */
    @JvmName("bktnqsvxgjutfrbd")
    public suspend fun linuxFxVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxFxVersion = mapped
    }

    /**
     * @param value Site load balancing.
     */
    @JvmName("wxieapopsrewllwh")
    public suspend fun loadBalancing(`value`: SiteLoadBalancing?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancing = mapped
    }

    /**
     * @param value <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
     */
    @JvmName("vrtgsrccvjogltbc")
    public suspend fun localMySqlEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localMySqlEnabled = mapped
    }

    /**
     * @param value HTTP logs directory size limit.
     */
    @JvmName("brhyluapftdstvux")
    public suspend fun logsDirectorySizeLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logsDirectorySizeLimit = mapped
    }

    /**
     * @param value Managed pipeline mode.
     */
    @JvmName("xhudelxhbijsifjd")
    public suspend fun managedPipelineMode(`value`: ManagedPipelineMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedPipelineMode = mapped
    }

    /**
     * @param value Managed Service Identity Id
     */
    @JvmName("kyseqdkwylhpfxgs")
    public suspend fun managedServiceIdentityId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedServiceIdentityId = mapped
    }

    /**
     * @param value Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("pboytjlqsbsshgwl")
    public suspend fun metadata(`value`: List<NameValuePairArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("seebpgjneklpdulo")
    public suspend fun metadata(argument: List<suspend NameValuePairArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NameValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("cvagagjgppjxhbqn")
    public suspend fun metadata(vararg argument: suspend NameValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NameValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("lktgdkgbppwqjyth")
    public suspend fun metadata(argument: suspend NameValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NameValuePairArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param values Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("plhhqrcbdgntrfqt")
    public suspend fun metadata(vararg values: NameValuePairArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value MinTlsVersion: configures the minimum version of TLS required for SSL requests
     */
    @JvmName("sqtgangpartvcpyv")
    public suspend fun minTlsVersion(`value`: Either<String, SupportedTlsVersions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minTlsVersion = mapped
    }

    /**
     * @param value MinTlsVersion: configures the minimum version of TLS required for SSL requests
     */
    @JvmName("dgkluuugwembhsmm")
    public fun minTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SupportedTlsVersions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minTlsVersion = mapped
    }

    /**
     * @param value MinTlsVersion: configures the minimum version of TLS required for SSL requests
     */
    @JvmName("rjdlejubjpimkpud")
    public fun minTlsVersion(`value`: SupportedTlsVersions) {
        val toBeMapped = Either.ofRight<String, SupportedTlsVersions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minTlsVersion = mapped
    }

    /**
     * @param value Number of minimum instance count for a site
     * This setting only applies to the Elastic Plans
     */
    @JvmName("rjvembncpudavyjd")
    public suspend fun minimumElasticInstanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumElasticInstanceCount = mapped
    }

    /**
     * @param value .NET Framework version.
     */
    @JvmName("hcppfdswflyofwwu")
    public suspend fun netFrameworkVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netFrameworkVersion = mapped
    }

    /**
     * @param value Version of Node.js.
     */
    @JvmName("itremgsutdtesdmm")
    public suspend fun nodeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeVersion = mapped
    }

    /**
     * @param value Number of workers.
     */
    @JvmName("kmkclkcqpuwmtutd")
    public suspend fun numberOfWorkers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfWorkers = mapped
    }

    /**
     * @param value Version of PHP.
     */
    @JvmName("xqrcyanjjuwweesi")
    public suspend fun phpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phpVersion = mapped
    }

    /**
     * @param value Version of PowerShell.
     */
    @JvmName("dxoadrmqggerkmbv")
    public suspend fun powerShellVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.powerShellVersion = mapped
    }

    /**
     * @param value Number of preWarmed instances.
     * This setting only applies to the Consumption and Elastic Plans
     */
    @JvmName("mvhvryqhockahmxe")
    public suspend fun preWarmedInstanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preWarmedInstanceCount = mapped
    }

    /**
     * @param value Property to allow or block all public traffic.
     */
    @JvmName("essxvbowkepjbhbj")
    public suspend fun publicNetworkAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Publishing user name.
     */
    @JvmName("eirmjuvvjsvuuhfr")
    public suspend fun publishingUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishingUsername = mapped
    }

    /**
     * @param value Push endpoint settings.
     */
    @JvmName("yrrtuapfarytpbku")
    public suspend fun push(`value`: PushSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.push = mapped
    }

    /**
     * @param argument Push endpoint settings.
     */
    @JvmName("okkebfukcswydqjr")
    public suspend fun push(argument: suspend PushSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PushSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.push = mapped
    }

    /**
     * @param value Version of Python.
     */
    @JvmName("uhcgtiarbfhpcxkr")
    public suspend fun pythonVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pythonVersion = mapped
    }

    /**
     * @param value <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
     */
    @JvmName("gylynchsdynytepx")
    public suspend fun remoteDebuggingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteDebuggingEnabled = mapped
    }

    /**
     * @param value Remote debugging version.
     */
    @JvmName("svoibdjtjcujexge")
    public suspend fun remoteDebuggingVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteDebuggingVersion = mapped
    }

    /**
     * @param value <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
     */
    @JvmName("ondaycuwbpkwecxp")
    public suspend fun requestTracingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTracingEnabled = mapped
    }

    /**
     * @param value Request tracing expiration time.
     */
    @JvmName("goavnikuieflokmr")
    public suspend fun requestTracingExpirationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTracingExpirationTime = mapped
    }

    /**
     * @param value IP security restrictions for scm.
     */
    @JvmName("vqmkeyhgeywwiaxc")
    public suspend fun scmIpSecurityRestrictions(`value`: List<IpSecurityRestrictionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scmIpSecurityRestrictions = mapped
    }

    /**
     * @param argument IP security restrictions for scm.
     */
    @JvmName("hpyaccmotndhrcxw")
    public suspend
    fun scmIpSecurityRestrictions(argument: List<suspend IpSecurityRestrictionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpSecurityRestrictionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scmIpSecurityRestrictions = mapped
    }

    /**
     * @param argument IP security restrictions for scm.
     */
    @JvmName("shueabofbttrgfwe")
    public suspend fun scmIpSecurityRestrictions(
        vararg
        argument: suspend IpSecurityRestrictionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IpSecurityRestrictionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scmIpSecurityRestrictions = mapped
    }

    /**
     * @param argument IP security restrictions for scm.
     */
    @JvmName("upfvbltskgdtlhib")
    public suspend
    fun scmIpSecurityRestrictions(argument: suspend IpSecurityRestrictionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpSecurityRestrictionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scmIpSecurityRestrictions = mapped
    }

    /**
     * @param values IP security restrictions for scm.
     */
    @JvmName("ijwqoekgphxiixxt")
    public suspend fun scmIpSecurityRestrictions(vararg values: IpSecurityRestrictionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmIpSecurityRestrictions = mapped
    }

    /**
     * @param value Default action for scm access restriction if no rules are matched.
     */
    @JvmName("felbqkeusqsadybh")
    public suspend
    fun scmIpSecurityRestrictionsDefaultAction(`value`: Either<String, DefaultAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scmIpSecurityRestrictionsDefaultAction = mapped
    }

    /**
     * @param value Default action for scm access restriction if no rules are matched.
     */
    @JvmName("blxyhcrbpjdwaxcm")
    public fun scmIpSecurityRestrictionsDefaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmIpSecurityRestrictionsDefaultAction = mapped
    }

    /**
     * @param value Default action for scm access restriction if no rules are matched.
     */
    @JvmName("jtaqrdqmfloudtoo")
    public fun scmIpSecurityRestrictionsDefaultAction(`value`: DefaultAction) {
        val toBeMapped = Either.ofRight<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmIpSecurityRestrictionsDefaultAction = mapped
    }

    /**
     * @param value IP security restrictions for scm to use main.
     */
    @JvmName("feptgxyfsorupxop")
    public suspend fun scmIpSecurityRestrictionsUseMain(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scmIpSecurityRestrictionsUseMain = mapped
    }

    /**
     * @param value ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
     */
    @JvmName("gujtogorkhbsdxkg")
    public suspend fun scmMinTlsVersion(`value`: Either<String, SupportedTlsVersions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scmMinTlsVersion = mapped
    }

    /**
     * @param value ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
     */
    @JvmName("tcexpltaenjspwau")
    public fun scmMinTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SupportedTlsVersions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmMinTlsVersion = mapped
    }

    /**
     * @param value ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
     */
    @JvmName("ofdqedxcgndxpkkp")
    public fun scmMinTlsVersion(`value`: SupportedTlsVersions) {
        val toBeMapped = Either.ofRight<String, SupportedTlsVersions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmMinTlsVersion = mapped
    }

    /**
     * @param value SCM type.
     */
    @JvmName("axqsqdpgwtpvkyrh")
    public suspend fun scmType(`value`: Either<String, ScmType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scmType = mapped
    }

    /**
     * @param value SCM type.
     */
    @JvmName("inhubauwfjilgwqm")
    public fun scmType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScmType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmType = mapped
    }

    /**
     * @param value SCM type.
     */
    @JvmName("jjppqkadrsyuspbx")
    public fun scmType(`value`: ScmType) {
        val toBeMapped = Either.ofRight<String, ScmType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmType = mapped
    }

    /**
     * @param value Tracing options.
     */
    @JvmName("dwdsevfhtpdlfpal")
    public suspend fun tracingOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracingOptions = mapped
    }

    /**
     * @param value <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
     */
    @JvmName("iytflyhmrufhmhfd")
    public suspend fun use32BitWorkerProcess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.use32BitWorkerProcess = mapped
    }

    /**
     * @param value Virtual applications.
     */
    @JvmName("mbvpeijjfokqciro")
    public suspend fun virtualApplications(`value`: List<VirtualApplicationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualApplications = mapped
    }

    /**
     * @param argument Virtual applications.
     */
    @JvmName("dauhevjrsmpltwmt")
    public suspend
    fun virtualApplications(argument: List<suspend VirtualApplicationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualApplicationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualApplications = mapped
    }

    /**
     * @param argument Virtual applications.
     */
    @JvmName("jwqiondxbkehxvjn")
    public suspend fun virtualApplications(
        vararg
        argument: suspend VirtualApplicationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualApplicationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualApplications = mapped
    }

    /**
     * @param argument Virtual applications.
     */
    @JvmName("bfaovexpkuluqjcm")
    public suspend
    fun virtualApplications(argument: suspend VirtualApplicationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualApplicationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualApplications = mapped
    }

    /**
     * @param values Virtual applications.
     */
    @JvmName("foxpoewwhqmojiiu")
    public suspend fun virtualApplications(vararg values: VirtualApplicationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualApplications = mapped
    }

    /**
     * @param value Virtual Network name.
     */
    @JvmName("iqejafpafcfwufrg")
    public suspend fun vnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetName = mapped
    }

    /**
     * @param value The number of private ports assigned to this app. These will be assigned dynamically on runtime.
     */
    @JvmName("gmbnxbeonuuojbky")
    public suspend fun vnetPrivatePortsCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetPrivatePortsCount = mapped
    }

    /**
     * @param value Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
     */
    @JvmName("vhbeojchbugbgdvf")
    public suspend fun vnetRouteAllEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetRouteAllEnabled = mapped
    }

    /**
     * @param value <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
     */
    @JvmName("sdwbdjoixrgequwv")
    public suspend fun webSocketsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webSocketsEnabled = mapped
    }

    /**
     * @param value Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones
     */
    @JvmName("liuuqvqcpdxjfpfn")
    public suspend fun websiteTimeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.websiteTimeZone = mapped
    }

    /**
     * @param value Xenon App Framework and version
     */
    @JvmName("agbmuxuomvtirasy")
    public suspend fun windowsFxVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsFxVersion = mapped
    }

    /**
     * @param value Explicit Managed Service Identity Id
     */
    @JvmName("bkjxukpiygjfyobb")
    public suspend fun xManagedServiceIdentityId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xManagedServiceIdentityId = mapped
    }

    internal fun build(): SiteConfigArgs = SiteConfigArgs(
        acrUseManagedIdentityCreds = acrUseManagedIdentityCreds,
        acrUserManagedIdentityID = acrUserManagedIdentityID,
        alwaysOn = alwaysOn,
        apiDefinition = apiDefinition,
        apiManagementConfig = apiManagementConfig,
        appCommandLine = appCommandLine,
        appSettings = appSettings,
        autoHealEnabled = autoHealEnabled,
        autoHealRules = autoHealRules,
        autoSwapSlotName = autoSwapSlotName,
        azureStorageAccounts = azureStorageAccounts,
        connectionStrings = connectionStrings,
        cors = cors,
        defaultDocuments = defaultDocuments,
        detailedErrorLoggingEnabled = detailedErrorLoggingEnabled,
        documentRoot = documentRoot,
        elasticWebAppScaleLimit = elasticWebAppScaleLimit,
        experiments = experiments,
        ftpsState = ftpsState,
        functionAppScaleLimit = functionAppScaleLimit,
        functionsRuntimeScaleMonitoringEnabled = functionsRuntimeScaleMonitoringEnabled,
        handlerMappings = handlerMappings,
        healthCheckPath = healthCheckPath,
        http20Enabled = http20Enabled,
        httpLoggingEnabled = httpLoggingEnabled,
        ipSecurityRestrictions = ipSecurityRestrictions,
        ipSecurityRestrictionsDefaultAction = ipSecurityRestrictionsDefaultAction,
        javaContainer = javaContainer,
        javaContainerVersion = javaContainerVersion,
        javaVersion = javaVersion,
        keyVaultReferenceIdentity = keyVaultReferenceIdentity,
        limits = limits,
        linuxFxVersion = linuxFxVersion,
        loadBalancing = loadBalancing,
        localMySqlEnabled = localMySqlEnabled,
        logsDirectorySizeLimit = logsDirectorySizeLimit,
        managedPipelineMode = managedPipelineMode,
        managedServiceIdentityId = managedServiceIdentityId,
        metadata = metadata,
        minTlsVersion = minTlsVersion,
        minimumElasticInstanceCount = minimumElasticInstanceCount,
        netFrameworkVersion = netFrameworkVersion,
        nodeVersion = nodeVersion,
        numberOfWorkers = numberOfWorkers,
        phpVersion = phpVersion,
        powerShellVersion = powerShellVersion,
        preWarmedInstanceCount = preWarmedInstanceCount,
        publicNetworkAccess = publicNetworkAccess,
        publishingUsername = publishingUsername,
        push = push,
        pythonVersion = pythonVersion,
        remoteDebuggingEnabled = remoteDebuggingEnabled,
        remoteDebuggingVersion = remoteDebuggingVersion,
        requestTracingEnabled = requestTracingEnabled,
        requestTracingExpirationTime = requestTracingExpirationTime,
        scmIpSecurityRestrictions = scmIpSecurityRestrictions,
        scmIpSecurityRestrictionsDefaultAction = scmIpSecurityRestrictionsDefaultAction,
        scmIpSecurityRestrictionsUseMain = scmIpSecurityRestrictionsUseMain,
        scmMinTlsVersion = scmMinTlsVersion,
        scmType = scmType,
        tracingOptions = tracingOptions,
        use32BitWorkerProcess = use32BitWorkerProcess,
        virtualApplications = virtualApplications,
        vnetName = vnetName,
        vnetPrivatePortsCount = vnetPrivatePortsCount,
        vnetRouteAllEnabled = vnetRouteAllEnabled,
        webSocketsEnabled = webSocketsEnabled,
        websiteTimeZone = websiteTimeZone,
        windowsFxVersion = windowsFxVersion,
        xManagedServiceIdentityId = xManagedServiceIdentityId,
    )
}
