@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.SkuCapacityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of the App Service plan scale options.
 * @property default Default number of workers for this App Service plan SKU.
 * @property elasticMaximum Maximum number of Elastic workers for this App Service plan SKU.
 * @property maximum Maximum number of workers for this App Service plan SKU.
 * @property minimum Minimum number of workers for this App Service plan SKU.
 * @property scaleType Available scale configurations for an App Service plan.
 */
public data class SkuCapacityArgs(
    public val default: Output<Int>? = null,
    public val elasticMaximum: Output<Int>? = null,
    public val maximum: Output<Int>? = null,
    public val minimum: Output<Int>? = null,
    public val scaleType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.SkuCapacityArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.SkuCapacityArgs =
        com.pulumi.azurenative.web.inputs.SkuCapacityArgs.builder()
            .default_(default?.applyValue({ args0 -> args0 }))
            .elasticMaximum(elasticMaximum?.applyValue({ args0 -> args0 }))
            .maximum(maximum?.applyValue({ args0 -> args0 }))
            .minimum(minimum?.applyValue({ args0 -> args0 }))
            .scaleType(scaleType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuCapacityArgs].
 */
@PulumiTagMarker
public class SkuCapacityArgsBuilder internal constructor() {
    private var default: Output<Int>? = null

    private var elasticMaximum: Output<Int>? = null

    private var maximum: Output<Int>? = null

    private var minimum: Output<Int>? = null

    private var scaleType: Output<String>? = null

    /**
     * @param value Default number of workers for this App Service plan SKU.
     */
    @JvmName("ctndroteppwmwigy")
    public suspend fun default(`value`: Output<Int>) {
        this.default = value
    }

    /**
     * @param value Maximum number of Elastic workers for this App Service plan SKU.
     */
    @JvmName("iwutgdskwoyopysl")
    public suspend fun elasticMaximum(`value`: Output<Int>) {
        this.elasticMaximum = value
    }

    /**
     * @param value Maximum number of workers for this App Service plan SKU.
     */
    @JvmName("dtybyfjcucdqqcmx")
    public suspend fun maximum(`value`: Output<Int>) {
        this.maximum = value
    }

    /**
     * @param value Minimum number of workers for this App Service plan SKU.
     */
    @JvmName("mpelvisnsdcwmcqv")
    public suspend fun minimum(`value`: Output<Int>) {
        this.minimum = value
    }

    /**
     * @param value Available scale configurations for an App Service plan.
     */
    @JvmName("wifhgnvubokoasrv")
    public suspend fun scaleType(`value`: Output<String>) {
        this.scaleType = value
    }

    /**
     * @param value Default number of workers for this App Service plan SKU.
     */
    @JvmName("caykjsrdgoyiadmm")
    public suspend fun default(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param value Maximum number of Elastic workers for this App Service plan SKU.
     */
    @JvmName("eoqxvskqlounlikr")
    public suspend fun elasticMaximum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticMaximum = mapped
    }

    /**
     * @param value Maximum number of workers for this App Service plan SKU.
     */
    @JvmName("nqijquaisfjublxe")
    public suspend fun maximum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximum = mapped
    }

    /**
     * @param value Minimum number of workers for this App Service plan SKU.
     */
    @JvmName("qinewtowrtiuashx")
    public suspend fun minimum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimum = mapped
    }

    /**
     * @param value Available scale configurations for an App Service plan.
     */
    @JvmName("pgwvnbwnmupbuxfr")
    public suspend fun scaleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleType = mapped
    }

    internal fun build(): SkuCapacityArgs = SkuCapacityArgs(
        default = default,
        elasticMaximum = elasticMaximum,
        maximum = maximum,
        minimum = minimum,
        scaleType = scaleType,
    )
}
