@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.SkuDescriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Description of a SKU for a scalable resource.
 * @property capabilities Capabilities of the SKU, e.g., is traffic manager enabled?
 * @property capacity Current number of instances assigned to the resource.
 * @property family Family code of the resource SKU.
 * @property locations Locations of the SKU.
 * @property name Name of the resource SKU.
 * @property size Size specifier of the resource SKU.
 * @property skuCapacity Min, max, and default scale values of the SKU.
 * @property tier Service tier of the resource SKU.
 */
public data class SkuDescriptionArgs(
    public val capabilities: Output<List<CapabilityArgs>>? = null,
    public val capacity: Output<Int>? = null,
    public val family: Output<String>? = null,
    public val locations: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val size: Output<String>? = null,
    public val skuCapacity: Output<SkuCapacityArgs>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.SkuDescriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.SkuDescriptionArgs =
        com.pulumi.azurenative.web.inputs.SkuDescriptionArgs.builder()
            .capabilities(
                capabilities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .skuCapacity(skuCapacity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuDescriptionArgs].
 */
@PulumiTagMarker
public class SkuDescriptionArgsBuilder internal constructor() {
    private var capabilities: Output<List<CapabilityArgs>>? = null

    private var capacity: Output<Int>? = null

    private var family: Output<String>? = null

    private var locations: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var size: Output<String>? = null

    private var skuCapacity: Output<SkuCapacityArgs>? = null

    private var tier: Output<String>? = null

    /**
     * @param value Capabilities of the SKU, e.g., is traffic manager enabled?
     */
    @JvmName("xkjuhxwusofgbisn")
    public suspend fun capabilities(`value`: Output<List<CapabilityArgs>>) {
        this.capabilities = value
    }

    @JvmName("opkxoqkpslywfebc")
    public suspend fun capabilities(vararg values: Output<CapabilityArgs>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values Capabilities of the SKU, e.g., is traffic manager enabled?
     */
    @JvmName("ktoxsluqsbyxuslf")
    public suspend fun capabilities(values: List<Output<CapabilityArgs>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value Current number of instances assigned to the resource.
     */
    @JvmName("cxqlncblskxbnjbs")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Family code of the resource SKU.
     */
    @JvmName("oftnihuirqqpqmgx")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value Locations of the SKU.
     */
    @JvmName("wsqgqxsxkslvkboq")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("mihhdjrduomwrjaw")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values Locations of the SKU.
     */
    @JvmName("tvwawcgyuyotnohh")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value Name of the resource SKU.
     */
    @JvmName("dcygqsrqkascdvtq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Size specifier of the resource SKU.
     */
    @JvmName("apmlwwdmkvqxbrvn")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value Min, max, and default scale values of the SKU.
     */
    @JvmName("epntoeiqeykddviy")
    public suspend fun skuCapacity(`value`: Output<SkuCapacityArgs>) {
        this.skuCapacity = value
    }

    /**
     * @param value Service tier of the resource SKU.
     */
    @JvmName("tvauikbpwfrxelub")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value Capabilities of the SKU, e.g., is traffic manager enabled?
     */
    @JvmName("klmbgpwbosbicmwd")
    public suspend fun capabilities(`value`: List<CapabilityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param argument Capabilities of the SKU, e.g., is traffic manager enabled?
     */
    @JvmName("mohsjsicaerpmtek")
    public suspend fun capabilities(argument: List<suspend CapabilityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CapabilityArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument Capabilities of the SKU, e.g., is traffic manager enabled?
     */
    @JvmName("astticphgfbcmvpc")
    public suspend fun capabilities(vararg argument: suspend CapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CapabilityArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument Capabilities of the SKU, e.g., is traffic manager enabled?
     */
    @JvmName("qxhlsrkwcleavolk")
    public suspend fun capabilities(argument: suspend CapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CapabilityArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param values Capabilities of the SKU, e.g., is traffic manager enabled?
     */
    @JvmName("pxkrecbbqaylolaf")
    public suspend fun capabilities(vararg values: CapabilityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value Current number of instances assigned to the resource.
     */
    @JvmName("xgvcagitnlaqbfkv")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Family code of the resource SKU.
     */
    @JvmName("dnwiswkvvxfdodnh")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value Locations of the SKU.
     */
    @JvmName("wybysjjclamyvtny")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values Locations of the SKU.
     */
    @JvmName("helklfqrpnrhadif")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value Name of the resource SKU.
     */
    @JvmName("minpplpsiwfdyrml")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Size specifier of the resource SKU.
     */
    @JvmName("ufcnkepyhxccqnej")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value Min, max, and default scale values of the SKU.
     */
    @JvmName("qqvgiyvaxyhvqrfa")
    public suspend fun skuCapacity(`value`: SkuCapacityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skuCapacity = mapped
    }

    /**
     * @param argument Min, max, and default scale values of the SKU.
     */
    @JvmName("biypchuptkjyrlbp")
    public suspend fun skuCapacity(argument: suspend SkuCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = SkuCapacityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.skuCapacity = mapped
    }

    /**
     * @param value Service tier of the resource SKU.
     */
    @JvmName("djpsnyvfkrfhghtf")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuDescriptionArgs = SkuDescriptionArgs(
        capabilities = capabilities,
        capacity = capacity,
        family = family,
        locations = locations,
        name = name,
        size = size,
        skuCapacity = skuCapacity,
        tier = tier,
    )
}
