@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.TokenStoreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The configuration settings of the token store.
 * @property azureBlobStorage The configuration settings of the storage of the tokens if blob storage is used.
 * @property enabled <code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.
 *  The default is <code>false</code>.
 * @property fileSystem The configuration settings of the storage of the tokens if a file system is used.
 * @property tokenRefreshExtensionHours The number of hours after session token expiration that a session token can be used to
 * call the token refresh API. The default is 72 hours.
 */
public data class TokenStoreArgs(
    public val azureBlobStorage: Output<BlobStorageTokenStoreArgs>? = null,
    public val enabled: Output<Boolean>? = null,
    public val fileSystem: Output<FileSystemTokenStoreArgs>? = null,
    public val tokenRefreshExtensionHours: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.TokenStoreArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.TokenStoreArgs =
        com.pulumi.azurenative.web.inputs.TokenStoreArgs.builder()
            .azureBlobStorage(azureBlobStorage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .fileSystem(fileSystem?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tokenRefreshExtensionHours(tokenRefreshExtensionHours?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TokenStoreArgs].
 */
@PulumiTagMarker
public class TokenStoreArgsBuilder internal constructor() {
    private var azureBlobStorage: Output<BlobStorageTokenStoreArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var fileSystem: Output<FileSystemTokenStoreArgs>? = null

    private var tokenRefreshExtensionHours: Output<Double>? = null

    /**
     * @param value The configuration settings of the storage of the tokens if blob storage is used.
     */
    @JvmName("bqvdksrfsyfcgtkw")
    public suspend fun azureBlobStorage(`value`: Output<BlobStorageTokenStoreArgs>) {
        this.azureBlobStorage = value
    }

    /**
     * @param value <code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.
     *  The default is <code>false</code>.
     */
    @JvmName("ovxhyxpggyibkjdv")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The configuration settings of the storage of the tokens if a file system is used.
     */
    @JvmName("akkhtjfefsejukfy")
    public suspend fun fileSystem(`value`: Output<FileSystemTokenStoreArgs>) {
        this.fileSystem = value
    }

    /**
     * @param value The number of hours after session token expiration that a session token can be used to
     * call the token refresh API. The default is 72 hours.
     */
    @JvmName("pvpicaskiknomxhx")
    public suspend fun tokenRefreshExtensionHours(`value`: Output<Double>) {
        this.tokenRefreshExtensionHours = value
    }

    /**
     * @param value The configuration settings of the storage of the tokens if blob storage is used.
     */
    @JvmName("kjialasbqpwfmgmn")
    public suspend fun azureBlobStorage(`value`: BlobStorageTokenStoreArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureBlobStorage = mapped
    }

    /**
     * @param argument The configuration settings of the storage of the tokens if blob storage is used.
     */
    @JvmName("aviwyslehyrrwjwl")
    public suspend
    fun azureBlobStorage(argument: suspend BlobStorageTokenStoreArgsBuilder.() -> Unit) {
        val toBeMapped = BlobStorageTokenStoreArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureBlobStorage = mapped
    }

    /**
     * @param value <code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.
     *  The default is <code>false</code>.
     */
    @JvmName("cqpnsvmffbmbgbvb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The configuration settings of the storage of the tokens if a file system is used.
     */
    @JvmName("ckxsapclpnbuljwh")
    public suspend fun fileSystem(`value`: FileSystemTokenStoreArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystem = mapped
    }

    /**
     * @param argument The configuration settings of the storage of the tokens if a file system is used.
     */
    @JvmName("qitgujelsbtmtvgv")
    public suspend fun fileSystem(argument: suspend FileSystemTokenStoreArgsBuilder.() -> Unit) {
        val toBeMapped = FileSystemTokenStoreArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fileSystem = mapped
    }

    /**
     * @param value The number of hours after session token expiration that a session token can be used to
     * call the token refresh API. The default is 72 hours.
     */
    @JvmName("tgyaqmbxxigflarf")
    public suspend fun tokenRefreshExtensionHours(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenRefreshExtensionHours = mapped
    }

    internal fun build(): TokenStoreArgs = TokenStoreArgs(
        azureBlobStorage = azureBlobStorage,
        enabled = enabled,
        fileSystem = fileSystem,
        tokenRefreshExtensionHours = tokenRefreshExtensionHours,
    )
}
