@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The configuration settings of the Azure Active Directory token validation flow.
 * @property allowedAudiences The list of audiences that can make successful authentication/authorization requests.
 * @property defaultAuthorizationPolicy The configuration settings of the default authorization policy.
 * @property jwtClaimChecks The configuration settings of the checks that should be made while validating the JWT Claims.
 */
public data class AzureActiveDirectoryValidationResponse(
    public val allowedAudiences: List<String>? = null,
    public val defaultAuthorizationPolicy: DefaultAuthorizationPolicyResponse? = null,
    public val jwtClaimChecks: JwtClaimChecksResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AzureActiveDirectoryValidationResponse):
            AzureActiveDirectoryValidationResponse = AzureActiveDirectoryValidationResponse(
            allowedAudiences = javaType.allowedAudiences().map({ args0 -> args0 }),
            defaultAuthorizationPolicy = javaType.defaultAuthorizationPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.DefaultAuthorizationPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            jwtClaimChecks = javaType.jwtClaimChecks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.JwtClaimChecksResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
