@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Database connection string information.
 * @property connectionString Connection string value.
 * @property name Name of connection string.
 * @property type Type of database.
 */
public data class ConnStringInfoResponse(
    public val connectionString: String? = null,
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ConnStringInfoResponse):
            ConnStringInfoResponse = ConnStringInfoResponse(
            connectionString = javaType.connectionString().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
