@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Cross-Origin Resource Sharing (CORS) settings for the app.
 * @property allowedOrigins Gets or sets the list of origins that should be allowed to make cross-origin
 * calls (for example: http://example.com:12345). Use "*" to allow all.
 * @property supportCredentials Gets or sets whether CORS requests with credentials are allowed. See
 * https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
 * for more details.
 */
public data class CorsSettingsResponse(
    public val allowedOrigins: List<String>? = null,
    public val supportCredentials: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.CorsSettingsResponse):
            CorsSettingsResponse = CorsSettingsResponse(
            allowedOrigins = javaType.allowedOrigins().map({ args0 -> args0 }),
            supportCredentials = javaType.supportCredentials().map({ args0 -> args0 }).orElse(null),
        )
    }
}
