@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Container App Dapr configuration.
 * @property appId Dapr application identifier
 * @property appPort Port on which the Dapr side car
 * @property components Collection of Dapr components
 * @property enabled Boolean indicating if the Dapr side car is enabled
 */
public data class DaprResponse(
    public val appId: String? = null,
    public val appPort: Int? = null,
    public val components: List<DaprComponentResponse>? = null,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.DaprResponse): DaprResponse =
            DaprResponse(
                appId = javaType.appId().map({ args0 -> args0 }).orElse(null),
                appPort = javaType.appPort().map({ args0 -> args0 }).orElse(null),
                components = javaType.components().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.web.kotlin.outputs.DaprComponentResponse.Companion.toKotlin(args0)
                    })
                }),
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
