@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the Facebook provider.
 * @property enabled <code>false</code> if the Facebook provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property graphApiVersion The version of the Facebook api to be used while logging in.
 * @property login The configuration settings of the login flow.
 * @property registration The configuration settings of the app registration for the Facebook provider.
 */
public data class FacebookResponse(
    public val enabled: Boolean? = null,
    public val graphApiVersion: String? = null,
    public val login: LoginScopesResponse? = null,
    public val registration: AppRegistrationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.FacebookResponse):
            FacebookResponse = FacebookResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            graphApiVersion = javaType.graphApiVersion().map({ args0 -> args0 }).orElse(null),
            login = javaType.login().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.LoginScopesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            registration = javaType.registration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AppRegistrationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
