@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Static Site User Provided Function App ARM resource.
 * @property createdOn The date and time on which the function app was registered with the static site.
 * @property functionAppRegion The region of the function app registered with the static site
 * @property functionAppResourceId The resource id of the function app registered with the static site
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property type Resource type.
 */
public data class GetStaticSiteUserProvidedFunctionAppForStaticSiteResult(
    public val createdOn: String,
    public val functionAppRegion: String? = null,
    public val functionAppResourceId: String? = null,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetStaticSiteUserProvidedFunctionAppForStaticSiteResult):
            GetStaticSiteUserProvidedFunctionAppForStaticSiteResult =
            GetStaticSiteUserProvidedFunctionAppForStaticSiteResult(
                createdOn = javaType.createdOn(),
                functionAppRegion = javaType.functionAppRegion().map({ args0 -> args0 }).orElse(null),
                functionAppResourceId = javaType.functionAppResourceId().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                type = javaType.type(),
            )
    }
}
