@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Hybrid Connection for an App Service app.
 * @property biztalkUri
 * @property entityConnectionString
 * @property entityName
 * @property hostname
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property port
 * @property resourceConnectionString
 * @property resourceType
 * @property type Resource type.
 */
public data class GetWebAppRelayServiceConnectionResult(
    public val biztalkUri: String? = null,
    public val entityConnectionString: String? = null,
    public val entityName: String? = null,
    public val hostname: String? = null,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val port: Int? = null,
    public val resourceConnectionString: String? = null,
    public val resourceType: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppRelayServiceConnectionResult):
            GetWebAppRelayServiceConnectionResult = GetWebAppRelayServiceConnectionResult(
            biztalkUri = javaType.biztalkUri().map({ args0 -> args0 }).orElse(null),
            entityConnectionString = javaType.entityConnectionString().map({ args0 -> args0 }).orElse(null),
            entityName = javaType.entityName().map({ args0 -> args0 }).orElse(null),
            hostname = javaType.hostname().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            resourceConnectionString = javaType.resourceConnectionString().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
