@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Source control configuration for an app.
 * @property branch Name of branch to use for deployment.
 * @property deploymentRollbackEnabled <code>true</code> to enable deployment rollback; otherwise, <code>false</code>.
 * @property gitHubActionConfiguration If GitHub Action is selected, than the associated configuration.
 * @property id Resource Id.
 * @property isGitHubAction <code>true</code> if this is deployed via GitHub action.
 * @property isManualIntegration <code>true</code> to limit to manual integration; <code>false</code> to enable continuous integration (which configures webhooks into online repos like GitHub).
 * @property isMercurial <code>true</code> for a Mercurial repository; <code>false</code> for a Git repository.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property repoUrl Repository or source control URL.
 * @property type Resource type.
 */
public data class GetWebAppSourceControlResult(
    public val branch: String? = null,
    public val deploymentRollbackEnabled: Boolean? = null,
    public val gitHubActionConfiguration: GitHubActionConfigurationResponse? = null,
    public val id: String,
    public val isGitHubAction: Boolean? = null,
    public val isManualIntegration: Boolean? = null,
    public val isMercurial: Boolean? = null,
    public val kind: String? = null,
    public val name: String,
    public val repoUrl: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppSourceControlResult):
            GetWebAppSourceControlResult = GetWebAppSourceControlResult(
            branch = javaType.branch().map({ args0 -> args0 }).orElse(null),
            deploymentRollbackEnabled = javaType.deploymentRollbackEnabled().map({ args0 ->
                args0
            }).orElse(null),
            gitHubActionConfiguration = javaType.gitHubActionConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.GitHubActionConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            isGitHubAction = javaType.isGitHubAction().map({ args0 -> args0 }).orElse(null),
            isManualIntegration = javaType.isManualIntegration().map({ args0 -> args0 }).orElse(null),
            isMercurial = javaType.isMercurial().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            repoUrl = javaType.repoUrl().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
