@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Virtual Network information ARM resource.
 * @property certBlob A certificate file (.cer) blob containing the public key of the private key used to authenticate a
 * Point-To-Site VPN connection.
 * @property certThumbprint The client certificate thumbprint.
 * @property dnsServers DNS servers to be used by this Virtual Network. This should be a comma-separated list of IP addresses.
 * @property id Resource Id.
 * @property isSwift Flag that is used to denote if this is VNET injection
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property resyncRequired <code>true</code> if a resync is required; otherwise, <code>false</code>.
 * @property routes The routes that this Virtual Network connection uses.
 * @property type Resource type.
 * @property vnetResourceId The Virtual Network's resource ID.
 */
public data class GetWebAppVnetConnectionSlotResult(
    public val certBlob: String? = null,
    public val certThumbprint: String,
    public val dnsServers: String? = null,
    public val id: String,
    public val isSwift: Boolean? = null,
    public val kind: String? = null,
    public val name: String,
    public val resyncRequired: Boolean,
    public val routes: List<VnetRouteResponse>,
    public val type: String,
    public val vnetResourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppVnetConnectionSlotResult):
            GetWebAppVnetConnectionSlotResult = GetWebAppVnetConnectionSlotResult(
            certBlob = javaType.certBlob().map({ args0 -> args0 }).orElse(null),
            certThumbprint = javaType.certThumbprint(),
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isSwift = javaType.isSwift().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            resyncRequired = javaType.resyncRequired(),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.VnetRouteResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            vnetResourceId = javaType.vnetResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
