@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The GitHub action code configuration.
 * @property runtimeStack Runtime stack is used to determine the workflow file content for code base apps.
 * @property runtimeVersion Runtime version is used to determine what build version to set in the workflow file.
 */
public data class GitHubActionCodeConfigurationResponse(
    public val runtimeStack: String? = null,
    public val runtimeVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GitHubActionCodeConfigurationResponse):
            GitHubActionCodeConfigurationResponse = GitHubActionCodeConfigurationResponse(
            runtimeStack = javaType.runtimeStack().map({ args0 -> args0 }).orElse(null),
            runtimeVersion = javaType.runtimeVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
